% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heplot1d.R
\name{heplot1d}
\alias{heplot1d}
\alias{heplot1d.mlm}
\title{One-Dimensional HE Plots}
\usage{
heplot1d(mod, ...)

\method{heplot1d}{mlm}(
  mod,
  terms,
  hypotheses,
  term.labels = TRUE,
  hyp.labels = TRUE,
  variables = 1,
  error.ellipse = !add,
  factor.means = !add,
  grand.mean = !add,
  remove.intercept = TRUE,
  type = c("II", "III", "2", "3"),
  idata = NULL,
  idesign = NULL,
  icontrasts = c("contr.sum", "contr.poly"),
  imatrix = NULL,
  iterm = NULL,
  manova,
  size = c("evidence", "effect.size", "significance"),
  level = 0.68,
  alpha = 0.05,
  center.pch = "|",
  col = getOption("heplot.colors", c("red", "blue", "black", "darkgreen", "darkcyan",
    "magenta", "brown", "darkgray")),
  lty = 2:1,
  lwd = 1:2,
  xlab,
  main = "",
  xlim,
  axes = TRUE,
  offset.axes = 0.1,
  add = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{mod}{a model object of class \code{"mlm"}.}

\item{\dots}{arguments to pass down to \code{plot}, \code{text}, and \code{points}.}

\item{terms}{a logical value or character vector of terms in the model for
which to plot hypothesis matrices; if missing or \code{TRUE}, defaults to
all terms; if \code{FALSE}, no terms are plotted.}

\item{hypotheses}{optional list of linear hypotheses for which to plot
hypothesis matrices; hypotheses are specified as for the
\code{\link[car]{linearHypothesis}} function in the \code{car} package; the
list elements can be named, in which case the names are used.}

\item{term.labels}{logical value or character vector of names for the terms
to be plotted. If \code{TRUE} (the default) the names of the terms are used;
if \code{FALSE}, term labels are not plotted.}

\item{hyp.labels}{logical value or character vector of names for the
hypotheses to be plotted. If \code{TRUE} (the default) the names of
components of the list of hypotheses are used; if \code{FALSE}, hypothesis
labels are not plotted.}

\item{variables}{indices or names of the two response variables to be
plotted; defaults to \code{1:2}.}

\item{error.ellipse}{if \code{TRUE}, plot the error ellipse; defaults to
\code{TRUE}, if the argument \code{add} is \code{FALSE} (see below).}

\item{factor.means}{logical value or character vector of names of factors
for which the means are to be plotted, or \code{TRUE} or \code{FALSE};
defaults to \code{TRUE}, if the argument \code{add} is \code{FALSE} (see
below).}

\item{grand.mean}{if \code{TRUE}, plot the centroid for all of the data;
defaults to \code{TRUE}, if the argument \code{add} is \code{FALSE} (see
below).}

\item{remove.intercept}{if \code{TRUE} (the default), do not plot the
ellipse for the intercept even if it is in the MANOVA table.}

\item{type}{``type'' of sum-of-squares-and-products matrices to compute; one
of \code{"II"}, \code{"III"}, \code{"2"}, or \code{"3"}, where \code{"II"}
is the default (and \code{"2"} is a synonym).}

\item{idata}{an optional data frame giving a factor or factors defining the
intra-subject model for multivariate repeated-measures data.  See Details of
\code{\link[car]{Anova}} for an explanation of the intra-subject design and
for further explanation of the other arguments relating to intra-subject
factors.}

\item{idesign}{a one-sided model formula using the ``data'' in idata and
specifying the intra-subject design for repeated measure models.}

\item{icontrasts}{names of contrast-generating functions to be applied by
 default to factors and ordered factors, respectively, in the within-subject
``data''; the contrasts must produce an intra-subject model matrix in which
 different terms are orthogonal. The default is c("contr.sum", "contr.poly").}

\item{imatrix}{In lieu of \code{idata} and \code{idesign}, you can specify
the intra-subject design matrix directly via \code{imatrix}, in the form of
list of named elements.  Each element gives the columns of the
within-subject model matrix for an intra-subject term to be tested, and must
have as many rows as there are responses; the columns of the within-subject
model matrix for \emph{different} terms must be mutually orthogonal.}

\item{iterm}{For repeated measures designs, you must specify one
intra-subject term (a character string) to select the SSPE (E) matrix used
in the HE plot.  Hypothesis terms plotted include the \code{iterm} effect as
well as all interactions of \code{iterm} with \code{terms}.}

\item{manova}{optional \code{Anova.mlm} object for the model; if absent a
MANOVA is computed. Specifying the argument can therefore save computation
in repeated calls.}

\item{size}{how to scale the hypothesis ellipse relative to the error
ellipse; if \code{"evidence"}, the default, the scaling is done so that a
``significant'' hypothesis ellipse at level \code{alpha} extends outside of
the error ellipse. \code{size = "significance"} is a synonym and does the same thing.
If \code{"effect.size"}, the hypothesis ellipse is on the
same scale as the error ellipse.}

\item{level}{equivalent coverage of ellipse  (assuming normally-distributed errors).
This defaults to \code{0.68}, giving a standard 1 SD bivariate ellipse.}

\item{alpha}{significance level for Roy's greatest-root test statistic; if
\code{size="evidence"} or \code{size="significance"}, then the hypothesis ellipse is scaled so that it
just touches the error ellipse at the specified alpha level. A larger
hypothesis ellipse \emph{somewhere} in the space of the response variables
therefore indicates statistical significance; defaults to \code{0.05}.}

\item{center.pch}{character to use in plotting the centroid of the data;
defaults to \code{"|"}.}

\item{col}{a color or vector of colors to use in plotting ellipses; the
first color is used for the error ellipse; the remaining colors --- recycled
as necessary --- are used for the hypothesis ellipses.  A single color can
be given, in which case it is used for all ellipses.  For convenience, the
default colors for all heplots produced in a given session can be changed by
assigning a color vector via \code{options(heplot.colors =c(...)}.
Otherwise, the default colors are \code{c("red", "blue", "black",
"darkgreen", "darkcyan", "magenta", "brown", "darkgray")}.}

\item{lty}{vector of line types to use for plotting the ellipses; the first
is used for the error ellipse, the rest --- possibly recycled --- for the
hypothesis ellipses; a single line type can be given. Defaults to \code{2:1}.}

\item{lwd}{vector of line widths to use for plotting the ellipses; the first
is used for the error ellipse, the rest --- possibly recycled --- for the
hypothesis ellipses; a single line width can be given. Defaults to \code{1:2}.}

\item{xlab}{x-axis label; defaults to name of the x variable.}

\item{main}{main plot label; defaults to \code{""}.}

\item{xlim}{x-axis limits; if absent, will be computed from the data.}

\item{axes}{Whether to draw the x, y axes; defaults to \code{TRUE}}

\item{offset.axes}{proportion to extend the axes in each direction if
computed from the data; optional.}

\item{add}{if \code{TRUE}, add to the current plot; the default is
\code{FALSE}.  If \code{TRUE}, the error ellipse is not plotted.}

\item{verbose}{if \code{TRUE}, print the MANOVA table and details of
hypothesis tests; the default is \code{FALSE}.}
}
\value{
The function invisibly returns an object of class \code{"heplot1d"},
with coordinates for the various hypothesis ellipses and the error ellipse,
and the limits of the horizontal and vertical axes.  (No methods for
manipulating these objects are currently available.)

The components are: 
\item{H}{ranges for the hypothesis terms} 
\item{E}{range for E} 
\item{xlim}{x-axis limits}
}
\description{
This function plots a 1-dimensional representation of the hypothesis (H) and
error (E) sums-of-squares-and-products matrices for terms and linear
hypotheses in a multivariate linear model.
}
\details{
In particular, for a given response, the 1-D representations of H and E
matrices correspond to line segments.  The E ``ellipse'' is shown as a
filled rectangle whose width equals the mean squared error for that
response.  The H ``ellipse'' for each model term is shown as a line segment
whose length represents either the size of the effect or the evidence for
that effect.

\bold{This version is an initial sketch.  Details of the implementation are
subject to change.}
}
\examples{

## Plastics data
plastic.mod <- lm(cbind(tear, gloss, opacity) ~ rate*additive, data=Plastic)
heplot1d(plastic.mod, col=c("pink","blue"))
heplot1d(plastic.mod, col=c("pink","blue"),variables=2)
heplot1d(plastic.mod, col=c("pink","blue"),variables=3)

## Bees data
bees.mod <- lm(cbind(Iz,Iy) ~ caste*treat*time, data=Bees)
heplot1d(bees.mod)
heplot1d(bees.mod, variables=2)


}
\seealso{
\code{\link[car]{Anova}}, \code{\link[car]{linearHypothesis}} for
      hypothesis tests in \code{mlm}s

   \code{\link{heplot}}, \code{\link{heplot3d}}, \code{\link{pairs.mlm}} for
      other HE plot methods
}
\author{
Michael Friendly
}
\keyword{aplot}
\keyword{hplot}
\keyword{multivariate}
