% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdMTD_FSC.R
\name{hdMTD_FSC}
\alias{hdMTD_FSC}
\title{Forward Stepwise and Cut method for inference in MTD models}
\usage{
hdMTD_FSC(X, d, l, alpha = 0.05, mu = 1, xi = 0.5, A = NULL, ...)
}
\arguments{
\item{X}{A vector or single-column data frame containing a chain sample (\code{X[1]} is the most recent).}

\item{d}{A positive integer representing an upper bound for the chain order.}

\item{l}{A positive integer that sets the number of elements in the output vector.}

\item{alpha}{A positive real number used in the CUT threshold (which determines if two
distributions can be considered different). The larger the \code{alpha}, the greater
the distance required to consider that there is a difference between a set of distributions.
Defaulted to 0.05.}

\item{mu}{A positive real number such that \eqn{\code{mu}>(e^{\code{mu}}-1)/2}. \code{mu}
is also a component of the same threshold as \code{alpha}.}

\item{xi}{A positive real number, \code{xi} is also a component of the same threshold as
\code{alpha}.}

\item{A}{A vector with positive integers representing the state space. If not informed,
this function will set \code{A <- sort(unique(X))}.}

\item{...}{Additional arguments (not used in this function, but maintained for compatibility with \code{\link[=hdMTD]{hdMTD()}}.}
}
\value{
Returns a vector with the estimated relevant lag set using FSC algorithm.
}
\description{
A function for inference in MTD Markov chains with FSC method. This function estimates the relevant
lag set \eqn{\Lambda} of an MTD model through the FSC algorithm.
}
\details{
The "Forward Stepwise and Cut" (FSC) is an algorithm for inference in
Mixture Transition Distribution (MTD) models. It consists
in the application of the "Forward Stepwise" (FS) step followed by the CUT algorithm.
This method and its steps where developed by \href{http://jmlr.org/papers/v24/22-0266.html}{Ost and Takahashi}
and are specially useful for inference in high-order MTD Markov chains.
}
\examples{
X <- testChains[,1]
hdMTD_FSC(X,4,3,alpha=0.02)
hdMTD_FSC(X,4,2,alpha=0.001)

}
\references{
Ost, G. & Takahashi, D. Y. (2023).
Sparse Markov models for high-dimensional inference.
\emph{Journal of Machine Learning Research}, \emph{24}(279), 1-54.
\url{http://jmlr.org/papers/v24/22-0266.html}
}
