% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{gt_latex_dependencies}
\alias{gt_latex_dependencies}
\title{Get the LaTeX dependencies required for a \strong{gt} table}
\usage{
gt_latex_dependencies()
}
\value{
An object of class \code{knit_asis}.
}
\description{
When working with Rnw (Sweave) files or otherwise writing LaTeX code,
including a \strong{gt} table can be problematic if we don't have knowledge
of the LaTeX dependencies. For the most part, these dependencies are the
LaTeX packages that are required for rendering a \strong{gt} table.
\code{gt_latex_dependencies()} provides an object that can be used to provide the
LaTeX in an Rnw file, allowing \strong{gt} tables to work and not yield errors
due to missing packages.
}
\details{
Here is an example Rnw document that shows how \code{gt_latex_dependencies()}
can be used in conjunction with a \strong{gt} table:

\preformatted{
\%!sweave=knitr

\documentclass{article}

<<echo=FALSE>>=
library(gt)
 @

<<results='asis', echo=FALSE>>=
gt_latex_dependencies()
 @

\begin{document}

<<results='asis', echo=FALSE>>=
gt(exibble)
 @

\end{document}
}
}
\section{Function ID}{

8-30
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{row_group}()},
\code{\link{stub}()},
\code{\link{system_fonts}()},
\code{\link{unit_conversion}()}
}
\concept{helper functions}
