% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwe.R
\name{ppwe}
\alias{ppwe}
\title{Piecewise exponential cumulative distribution function}
\usage{
ppwe(x, duration, rate, lower_tail = FALSE)
}
\arguments{
\item{x}{Times at which distribution is to be computed.}

\item{duration}{A numeric vector of time duration.}

\item{rate}{A numeric vector of event rate.}

\item{lower_tail}{Indicator of whether lower (\code{TRUE}) or upper tail
(\code{FALSE}; default) of CDF is to be computed.}
}
\value{
A vector with cumulative distribution function or survival values.
}
\description{
Computes the cumulative distribution function (CDF) or survival rate
for a piecewise exponential distribution.
}
\details{
Suppose \eqn{\lambda_i} is the failure rate in the interval
\eqn{(t_{i-1},t_i], i=1,2,\ldots,M} where
\eqn{0=t_0<t_i\ldots,t_M=\infty}.
The cumulative hazard function at an arbitrary time \eqn{t>0} is then:

\deqn{\Lambda(t)=\sum_{i=1}^M \delta(t\leq t_i)(\min(t,t_i)-t_{i-1})\lambda_i.}
The survival at time \eqn{t} is then
\deqn{S(t)=\exp(-\Lambda(t)).}
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if input enrollment rate is a strictly increasing non-negative numeric vector.
   \item Validate if input failure rate is of type data.frame.
   \item Validate if input failure rate contains duration column.
   \item Validate if input failure rate contains rate column.
   \item Validate if input lower_tail is logical.
   \item Convert rates to step function.
   \item Add times where rates change to enrollment rates.
   \item Make a tibble of the input time points x, duration, hazard rates at points,
   cumulative hazard and survival.
   \item Extract the expected cumulative or survival of piecewise exponential distribution.
   \item If input lower_tail is true, return the CDF, else return the survival for \code{ppwe}
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{

# Plot a survival function with 2 different sets of time values
# to demonstrate plot precision corresponding to input parameters.

x1 <- seq(0, 10, 10 / pi)
duration <- c(3, 3, 1)
rate <- c(.2, .1, .005)

survival <- ppwe(
  x = x1,
  duration = duration,
  rate = rate
)
plot(x1, survival, type = "l", ylim = c(0, 1))

x2 <- seq(0, 10, .25)
survival <- ppwe(
  x = x2,
  duration = duration,
  rate = rate
)
lines(x2, survival, col = 2)
}
