% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPPM.R
\name{gppm}
\alias{gppm}
\title{Define a Gaussian process panel model}
\usage{
gppm(mFormula, cFormula, myData, ID, DV, control = gppmControl())
}
\arguments{
\item{mFormula}{character string. Contains the specification of the mean function. See details for more information.}

\item{cFormula}{character string. Contains the specification of the covariance function. See details for more information.}

\item{myData}{data frame. Contains the data to which the model is fitted. Must be in the long-format.}

\item{ID}{character string. Contains the column label in myData which describes the subject ID.}

\item{DV}{character string. Contains the column label in myData which contains the to be modeled variable.}

\item{control}{object of class GPPMControl. Used for storing technical settings. Default should only be changed by advanced users. Generated via \code{\link{gppmControl}}.}
}
\value{
A (unfitted) Gaussian process panel model, which is an object of class 'GPPM'
}
\description{
This function is used to specify a Gaussian process panel model (GPPM),
which can then be fit using \code{\link{fit.GPPM}}.
}
\details{
mFormula and cFormula contain the specification of the mean and the covariance function respectively.
These formulas are defined using character strings. Within these strings there are four basic elements:
\itemize{
\item Parameters
\item Functions and operators
\item References to observed variables in the data frame myData
\item Mathematical constants
}
The gppm function automatically recognizes which part of the string refers to which elements. To be able to do this certain relatively common rules need to be followed:

Parameters: Parameters may not have the same name as any of the columns in myData to avoid confusing them with a reference to an observed variable.
Furthermore, to avoid confusing them with functions, operators, or constants, parameter labels must always begin with a lower case letter and only contain letters and digits.

Functions and operators: All functions and operators that are supported by stan can be used; see \url{https://mc-stan.org/docs/} for a full list. In general, all basic operators and functions are supported.

References: A reference must be the same as one of the elements of the output of \code{names(myData)}. For references, the same rules apply as for parameters. That is, the column names of myData may only contain letters and digits and must start with a letter.

Constants: Again, all constants that are supported by stan can be used and in general the constants are available by their usual name.
}
\examples{
# Defintion of a latent growth curve model
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
}
}
\seealso{
\code{\link{fit.GPPM}} for how to fit a GPPM
}
