% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_stats.R
\name{padjust_genesets}
\alias{padjust_genesets}
\title{Adjust p-values for all genesets, grouped by 'source' then adjust for the number of 'sources'}
\usage{
padjust_genesets(
  genesets,
  method = "BH",
  cutoff = 0.01,
  correct_sources = TRUE
)
}
\arguments{
\item{genesets}{tibble with genesets, must contain column 'pvalue'}

\item{method}{method for multiple testing correction, must be any of \code{stats::p.adjust.methods}, e.g. "BH" or "bonferroni"}

\item{cutoff}{numeric cutoff value for adjusted p-value, \code{signif} column is set to TRUE for all values lesser-equals}

\item{correct_sources}{apply Bonferroni adjustment to all p-values according to the number of geneset sources that were tested. Boolean parameter, set TRUE to enable (default) or FALSE to disable}
}
\value{
updated \code{genesets} table
}
\description{
Adjust p-values for all genesets, grouped by 'source' then adjust for the number of 'sources'
}
