% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{radial_layout}
\alias{radial_layout}
\title{Generate G6 Radial layout configuration}
\usage{
radial_layout(
  center = NULL,
  focusNode = NULL,
  height = NULL,
  width = NULL,
  nodeSize = NULL,
  nodeSpacing = 10,
  linkDistance = 50,
  unitRadius = 100,
  maxIteration = 1000,
  maxPreventOverlapIteration = 200,
  preventOverlap = FALSE,
  sortBy = NULL,
  sortStrength = 10,
  strictRadial = TRUE,
  ...
)
}
\arguments{
\item{center}{Numeric vector of length 2. Center coordinates.}

\item{focusNode}{Character, list (Node), or NULL. Radiating center node. Defaults to NULL.}

\item{height}{Numeric. Canvas height.}

\item{width}{Numeric. Canvas width.}

\item{nodeSize}{Numeric. Node size (diameter).}

\item{nodeSpacing}{Numeric or function. Minimum node spacing (effective when preventing overlap). Defaults to 10.}

\item{linkDistance}{Numeric. Edge length. Defaults to 50.}

\item{unitRadius}{Numeric or NULL. Radius per circle. Defaults to 100.}

\item{maxIteration}{Numeric. Maximum number of iterations. Defaults to 1000.}

\item{maxPreventOverlapIteration}{Numeric. Max iterations for overlap prevention. Defaults to 200.}

\item{preventOverlap}{Logical. Whether to prevent node overlap. Defaults to FALSE.}

\item{sortBy}{Character. Field for sorting nodes in the same layer.}

\item{sortStrength}{Numeric. Sorting strength for nodes in the same layer. Defaults to 10.}

\item{strictRadial}{Logical. Strictly place nodes in the same layer on the same ring. Defaults to TRUE.}

\item{...}{Additional parameters to pass to the layout.
See \url{https://g6.antv.antgroup.com/en/manual/layout/radial-layout}.}
}
\value{
A list containing the configuration for G6 radial layout.
}
\description{
This function creates a configuration list for G6 Radial layout
with all available options as parameters.
}
\examples{
if (interactive()) {
  g6(jsonUrl = "https://assets.antv.antgroup.com/g6/radial.json") |>
    g6_layout(
      radial_layout(
        unitRadius = 100,
        linkDistance = 200
      )
    ) |>
    g6_behaviors(
      "zoom-canvas",
      drag_element()
    )
}

}
