% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-update-version.R
\name{update_version}
\alias{update_version}
\title{Update NEWS.md and DESCRIPTION with a new version}
\usage{
update_version(which = "dev")
}
\arguments{
\item{which}{Component of the version number to update. Supported
values are \code{"dev"} (default), \code{"patch"}, \code{"minor"} and \code{"major"}.}
}
\value{
None
}
\description{
Bumps a version component and adds to \code{NEWS.md} and \code{DESCRIPTION}.
}
\examples{
# Create mock package in a temporary directory.
# Set open to TRUE if you want to play in the mock package.
with_demo_project({
  # Use functions as if inside the newly created package project.
  # (Or go and actually run code inside the newly created package project!)
  # Add a new R file.
  usethis::use_r("cool-function", open = FALSE)
  # Pretend we added useful code inside it.
  # Track the new R file with Git.
  gert::git_add("R/cool-function.R")
  gert::git_commit("- Add cool function.")
  # Bump version with fledge.
  fledge::bump_version()
  fledge::update_news(c("- something I forgot", "- blabla"))
  fledge::update_version()
  gert::git_add("NEWS.md")
  gert::git_commit(message = "release notes tweaking")
  fledge::tag_version()
  print(fledge::get_last_tag())
})
}
