% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emMixRHLP.R
\name{emMixRHLP}
\alias{emMixRHLP}
\title{emMixRHLP implements the EM algorithm to fit a mixture of RHLP models.}
\usage{
emMixRHLP(X, Y, K, R, p = 3, q = 1,
  variance_type = c("heteroskedastic", "homoskedastic"),
  init_kmeans = TRUE, n_tries = 1, max_iter = 1000,
  threshold = 1e-05, verbose = FALSE, verbose_IRLS = FALSE)
}
\arguments{
\item{X}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{Y}{Matrix of size \eqn{(n, m)} representing the observed
responses/outputs. \code{Y} consists of \emph{n} functions of \code{X} observed at
points \eqn{1,\dots,m}.}

\item{K}{The number of clusters (Number of RHLP models).}

\item{R}{The number of regimes (RHLP components) for each cluster.}

\item{p}{Optional. The order of the polynomial regression. By default, \code{p} is
set at 3.}

\item{q}{Optional. The dimension of the logistic regression. For the purpose
of segmentation, it must be set to 1 (which is the default value).}

\item{variance_type}{Optional character indicating if the model is
"homoskedastic" or "heteroskedastic". By default the model is
"heteroskedastic".}

\item{init_kmeans}{Optional. A logical indicating whether or not the curve
partition should be initialized by the K-means algorithm. Otherwise the
curve partition is initialized randomly.}

\item{n_tries}{Optional. Number of runs of the EM algorithm. The solution
providing the highest log-likelihood will be returned.

If \code{n_tries} > 1, then for the first run, parameters are initialized by
uniformly segmenting the data into R segments, and for the next runs,
parameters are initialized by randomly segmenting the data into R
contiguous segments.}

\item{max_iter}{Optional. The maximum number of iterations for the EM
algorithm.}

\item{threshold}{Optional. A numeric value specifying the threshold for the
relative difference of log-likelihood between two steps of the EM as
stopping criteria.}

\item{verbose}{Optional. A logical value indicating whether or not values of
the log-likelihood should be printed during EM iterations.}

\item{verbose_IRLS}{Optional. A logical value indicating whether or not
values of the criterion optimized by IRLS should be printed at each step of
the EM algorithm.}
}
\value{
EM returns an object of class \link{ModelMixRHLP}.
}
\description{
emMixRHLP implements the maximum-likelihood parameter estimation of a mixture
of RHLP models by the Expectation-Maximization (EM) algorithm.
}
\details{
emMixRHLP function implements the EM algorithm. This function starts
with an initialization of the parameters done by the method \code{initParam} of
the class \link{ParamMixRHLP}, then it alternates between the
E-Step (method of the class \link{StatMixRHLP}) and the M-Step
(method of the class \link{ParamMixRHLP}) until convergence (until
the relative variation of log-likelihood between two steps of the EM
algorithm is less than the \code{threshold} parameter).
}
\examples{
data(toydataset)

# Let's fit a mixRHLP model on a dataset containing 2 clusters:
data <- toydataset[1:190,1:21]
x <- data$x
Y <- t(data[,2:ncol(data)])

mixrhlp <- emMixRHLP(X = x, Y = Y, K = 2, R = 2, p = 1, verbose = TRUE)

mixrhlp$summary()

mixrhlp$plot()
}
\seealso{
\link{ModelMixRHLP}, \link{ParamMixRHLP}, \link{StatMixRHLP}
}
