% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i18n.R
\name{i18n_t}
\alias{i18n_t}
\title{Translate a UI/message key}
\usage{
i18n_t(dict, key, default = NULL)
}
\arguments{
\item{dict}{Named list produced by \code{\link[=i18n_load]{i18n_load()}}.}

\item{key}{Character scalar; lookup key.}

\item{default}{Optional fallback value if the key is not present.}
}
\value{
Character scalar.
}
\description{
Returns the value for \code{key} from a dictionary produced by \code{\link[=i18n_load]{i18n_load()}}.
If the key is missing, returns \code{default} when provided, otherwise the key itself.
}
\examples{
# A quick, fully automatic check:
p <- system.file("shinyapp", "i18n", "en.json", package = "examly")
if (nzchar(p) && file.exists(p)) {
  d <- i18n_load("en")
  i18n_t(d, "buttons.download", "Download")
}
}
