% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSIS.R
\name{ModelSIS}
\alias{ModelSIS}
\alias{epiworld_sis}
\title{SIS model}
\usage{
ModelSIS(name, prevalence, transmission_rate, recovery_rate)
}
\arguments{
\item{name}{String. Name of the virus.}

\item{prevalence}{Double. Initial proportion of individuals with the virus.}

\item{transmission_rate}{Numeric scalar between 0 and 1. Virus's rate of
infection.}

\item{recovery_rate}{Numeric scalar between 0 and 1. Rate of recovery from virus.}
}
\value{
\itemize{
\item The \code{ModelSIS} function returns a model of class \link{epiworld_model}.
}
}
\description{
Susceptible-Infected-Susceptible model (SIS) (\href{https://en.wikipedia.org/w/index.php?title=Compartmental_models_in_epidemiology&oldid=1155757336#The_SIS_model}{wiki})
}
\section{Model diagram}{

\figure{sis.png}{SIS Diagram}
}

\examples{
model_sis <- ModelSIS(name = "COVID-19", prevalence = 0.01,
  transmission_rate = 0.9, recovery_rate = 0.1)

# Adding a small world population
agents_smallworld(
  model_sis,
  n = 1000,
  k = 5,
  d = FALSE,
  p = .01
)

# Running and printing
run(model_sis, ndays = 100, seed = 1912)
model_sis

# Plotting
plot(model_sis, main = "SIS Model")

}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelMeaslesMixing}()},
\code{\link{ModelMeaslesMixingRiskQuarantine}()},
\code{\link{ModelMeaslesSchool}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSEIRMixingQuarantine}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
\concept{general-models}
