% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div.r
\name{kulczynski}
\alias{kulczynski}
\title{Kulczynski}
\usage{
kulczynski(counts, weighted = TRUE, pairs = NULL, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{weighted}{If \code{TRUE}, the algorithm takes relative abundances into
account. If \code{FALSE}, only presence/absence is considered.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A \code{dist} object.
}
\description{
Kulczynski beta diversity metric.
}
\section{Calculation}{


In the formulas below, \code{x} and \code{y} are two columns (samples) from \code{counts}.
\code{n} is the number of rows (OTUs) in \code{counts}.

\deqn{t = \displaystyle \sum_{i = 1}^{n} min(x_i,y_i)}
\deqn{D = \displaystyle 1 - 0.5(\frac{t}{\sum_{i = 1}^{n} x_i} + \frac{t}{\sum_{i = 1}^{n} y_i})}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  x <- c(4, 0, 3, 2, 6)
  y <- c(0, 8, 0, 0, 5)
  t <- sum(pmin(x,y))
  1 - (t/sum(x) + t/sum(y)) / 2  
  #>  0.6410256
}\if{html}{\out{</div>}}
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Kulczynski weighted distance matrix
    kulczynski(ex_counts)
    
    # Kulczynski unweighted distance matrix
    kulczynski(ex_counts, weighted = FALSE)
    
    # Only calculate distances for A vs all.
    kulczynski(ex_counts, pairs = 1:3)
    
}
\references{
Kulcynski S 1927.
Die Pflanzenassoziationen der Pieninen.
Bulletin International de l'Académie Polonaise des Sciences et des Lettres, Classe des Sciences Mathématiques et Naturelles, Série B: Sciences Naturelles.
}
\seealso{
Other beta_diversity: 
\code{\link{bray_curtis}()},
\code{\link{canberra}()},
\code{\link{euclidean}()},
\code{\link{generalized_unifrac}()},
\code{\link{gower}()},
\code{\link{jaccard}()},
\code{\link{manhattan}()},
\code{\link{unweighted_unifrac}()},
\code{\link{variance_adjusted_unifrac}()},
\code{\link{weighted_normalized_unifrac}()},
\code{\link{weighted_unifrac}()}
}
\concept{beta_diversity}
