% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_selection.R
\name{ebnm_scale_npmle}
\alias{ebnm_scale_npmle}
\title{Set scale parameter for NPMLE and deconvolveR prior family}
\usage{
ebnm_scale_npmle(
  x,
  s,
  min_K = 3,
  max_K = 300,
  KLdiv_target = 1/length(x),
  pointmass = TRUE
)
}
\arguments{
\item{x}{A vector of observations. Missing observations (\code{NA}s) are
not allowed.}

\item{s}{A vector of standard errors (or a scalar if all are equal).
Standard errors may not be exactly zero, and missing standard errors are
not allowed.}

\item{min_K}{The minimum number of components \eqn{K} to include in the
mixture of point masses used to approximate the nonparametric family of
all distributions.}

\item{max_K}{The maximum number of components \eqn{K} to include in the
approximating mixture of point masses.}

\item{KLdiv_target}{The desired bound \eqn{\kappa} on the KL-divergence from
the solution obtained using the approximating mixture to the exact
solution. More precisely, the scale parameter is set such that given
the exact MLE
\deqn{\hat{g} := \mathrm{argmax}_{g \in G} L(g),}
where \eqn{G} is the full nonparametric family, and given the MLE for the
approximating family \eqn{\tilde{G}}
\deqn{\tilde{g} := \mathrm{argmax}_{g \in \tilde{G}} L(g),}
we have that
\deqn{\mathrm{KL}(\hat{g} \ast N(0, s^2) \mid \tilde{g} \ast N(0, s^2)) \le \kappa,}
where \eqn{\ast \ N(0, s^2)} denotes convolution with the normal error
distribution (the derivation of the bound assumes homoskedastic
observations). For details, see \strong{References} below.}

\item{pointmass}{When the range of the data is so large that \code{max_K}
  point masses cannot provide a good approximation to the family of all
  distributions, then \code{ebnm} will instead use a mixture of normal
  distributions, with the standard deviation of each component equal to
  \code{scale}\eqn{/ 2}. Setting \code{pointmass = FALSE} gives the
  default \code{scale} for this mixture of normal distributions.

  To be exact, \code{ebnm} uses a mixture of normal distributions rather than
  a mixture of point masses when
  \deqn{\frac{\max(x) - \min(x)}{\min(s)} > 3 \ \mathrm{max}_K;} for a
  rationale, see \strong{References} below. Note however that \code{ebnm}
  only uses a mixture of normal distributions when \code{scale = "estimate"};
  if parameter \code{scale} is set manually, then a mixture of point masses
  will be used in all cases. To use a mixture of normal distributions with
  the scale set manually, an object created by the constructor function
  \code{\link[ashr]{normalmix}} must be provided as argument to parameter
  \code{g_init} in function \code{\link{ebnm_npmle}} or function
  \code{\link{ebnm_deconvolver}}.}
}
\description{
The default method for setting the \code{scale} parameter for functions
  \code{\link{ebnm_npmle}} and \code{\link{ebnm_deconvolver}}.
}
\references{
Jason Willwerscheid (2021).
  \emph{Empirical Bayes Matrix Factorization: Methods and Applications}.
  University of Chicago, PhD dissertation.
}
