% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfMLR.R
\name{coef.ddfMLR}
\alias{coef.ddfMLR}
\alias{coefficients.ddfMLR}
\title{Extract model coefficients from an object of \code{"ddfMLR"} class.}
\usage{
\method{coef}{ddfMLR}(object, SE = FALSE, simplify = FALSE, IRTpars = TRUE, CI = 0.95, ...)
}
\arguments{
\item{object}{an object of \code{"ddfMLR"} class.}

\item{SE}{logical: should the standard errors of estimated
parameters be also returned? (default is \code{FALSE}).}

\item{simplify}{logical: should the estimated parameters be
simplified to a matrix? (default is \code{FALSE}).}

\item{IRTpars}{logical: should the estimated parameters be returned
in IRT parameterization? (default is \code{TRUE}).}

\item{CI}{numeric: level of confidence interval for parameters,
default is \code{0.95} for 95\% confidence interval.}

\item{...}{other generic parameters for \code{coef()} function.}
}
\description{
S3 method for extracting estimated model coefficients
  from an object of \code{"ddfMLR"} class.
}
\examples{
\dontrun{
# loading data
data(GMATtest, GMATkey)
Data <- GMATtest[, 1:20] # items
group <- GMATtest[, "group"] # group membership variable
key <- GMATkey # correct answers

# testing both DDF effects
(x <- ddfMLR(Data, group, focal.name = 1, key))

# estimated parameters
coef(x)
# includes standard errors
coef(x, SE = TRUE)
# includes standard errors and simplifies to matrix
coef(x, SE = TRUE, simplify = TRUE)
# intercept-slope parameterization
coef(x, IRTpars = FALSE)
# intercept-slope parameterization, simplifies to matrix, turn off confidence intervals
coef(x, IRTpars = FALSE, simplify = TRUE, CI = 0)
}
}
\seealso{
\code{\link[difNLR]{ddfMLR}} for DDF detection among nominal data. \cr
\code{\link[stats]{coef}} for generic function extracting model coefficients.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
