% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htypes.R
\name{htype}
\alias{htype}
\alias{htypes}
\alias{htypes.describe}
\alias{htypes.default}
\alias{is_hcat}
\alias{is_hcon}
\title{Type's checks accordingly to [Hmisc] package}
\usage{
htype(x, n_unique = 10L)

htypes(x, n_unique = 10L)

\method{htypes}{describe}(x, n_unique = 10L)

\method{htypes}{default}(x, n_unique = 10L)

is_hcat(x)

is_hcon(x, n_unique = 10L)
}
\arguments{
\item{x}{an instance of the class [describe][Hmisc::describe], in the
cases of "singular" functions (ie `is_*()` or `htype()`) it must
be a single-variable [describe][Hmisc::describe] object.}

\item{n_unique}{(int, 10L) the minimum number of distinct values a
numeric variable must have before plot.describe uses it in a
continuous variable plot.}
}
\value{
(chr) `htype` returns one of "cat" (if `x` will be considered
  categorical), "con" (if `x` will be considered continuous), "none"
  (if `x` will be not considered categorical nor continuous, and
  hence it will be not plotted), or "both" (with a warning, if the
  variable will be considered both categorical and continuous. This
  would possibly never happen).

(chr) character vector of the types identified by [htype] for
  every variable represented in (each element of) `x`.

(lgl) `is_hcat` returns TRUE if x will be considered
  categorical.

(lgl) `is_hcon` returns TRUE if x will be considered
  continuous.
}
\description{
These functions decide and report if a single variable represented by
a single instance of an `Hmisc`'s [describe][Hmisc::describe] object
will considered a categorical variable or a continuous one.
}
\details{
A "single" object of `Hmisc`'s [describe][Hmisc::describe]
  class represents a variable. When you plot and object of class
  [describe][Hmisc::describe] the plot function decide if it is a
  continuous variable or a categorical one to plot it in the
  correspond plot. It is also possible that the variable is not
  considered in none of that categories, in which case it will not be
  plotted at all.

  These functions have been produced/deduced from reading the
  source code of `Hmisc`'s [plot][Hmisc::describe]. In particular,
  from the definition of the (two distinct) functions `f` defined
  within it (one for categorical variables and the other for
  continuous variables). Both lead to a possible execution of
  `warning("no categorical variable found")` or `warning("no
  continuous variable found")`. I tried to keep the same
  names/code/logic that I found there.
}
\section{Functions}{
\itemize{
\item \code{htypes()}: Report types for multi-variables objects

\item \code{is_hcat()}: Check if a single-instance of a
[describe][Hmisc::describe] object is categorical.

\item \code{is_hcon()}: Check if a single-instance of a
[describe][Hmisc::describe] object is continuous.

}}
\examples{
\donttest{
  library(Hmisc)
  desc <- describe(mtcars)

  htype(desc[["vs"]]) # "cat"
  htype(desc[["mpg"]]) # "con"
  htype(desc[["cyl"]]) # "none"
}
\donttest{
  htypes(desc) # c(
  #   mpg = "con", cyl = "none", disp = "con",
  #   hp = "con", drat = "con", wt = "con", qsec = "con",
  #   vs = "cat", am = "cat", gear = "none",
  #   carb = "none"
  # )
}
\donttest{
  htypes(mtcars) # htypes(desc)
  htypes(letters) # "none"
}
\donttest{
  is_hcat(desc[["vs"]]) # TRUE
  is_hcat(desc[["mpg"]]) # FALSE
}
\donttest{
  is_hcon(desc[["vs"]]) # FALSE
  is_hcon(desc[["mpg"]]) # TRUE
}
}
\seealso{
[describe][Hmisc::describe],

[is_hdesc], [is_single_hdesc]

Gist with test and usage examples: https://bit.ly/htype-gist
}
