% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconcile.R
\name{reconcile_without_index}
\alias{reconcile_without_index}
\title{Reconcile Two Data Frames}
\usage{
reconcile_without_index(old_df, new_df, lookup_columns = NA)
}
\arguments{
\item{old_df}{A data frame containing the preceding version of the data,
used as the reference for comparison.}

\item{new_df}{A data frame containing the most recent version of the data.}

\item{lookup_columns}{A character vector specifying which columns should be
used for comparison. By default `NA`, meaning that all columns common to
both `new_df` and `old_df` are included. If one or more column names are
provided, only those columns will be compared.}
}
\value{
A data frame summarizing differences between `new_df` and `old_df`,
including which columns changed and the details of those changes.
}
\description{
This function compares two data frames —`new_df` (the updated version) and
`old_df` (the previous version) —to identify differences between them.
The comparison can be performed across all shared columns or restricted
to a specified subset of columns.
}
\author{
Lukasz Andrzejewski
}
