% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_margins_ord.R
\name{util_margins_ord}
\alias{util_margins_ord}
\title{Utility function to create a plot similar to the margins plots for ordinal variables}
\usage{
util_margins_ord(
  resp_vars = NULL,
  group_vars = NULL,
  co_vars = NULL,
  min_obs_in_subgroup = 5,
  min_subgroups = 5,
  ds1,
  label_col,
  adjusted_hint = "",
  title = "",
  sort_group_var_levels = getOption("dataquieR.acc_margins_sort",
    dataquieR.acc_margins_sort_default)
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the ordinal measurement variable}

\item{group_vars}{\link{variable} the name of the observer, device or
reader variable}

\item{co_vars}{\link{variable list} a vector of covariables, e.g. age and sex for
adjustment}

\item{min_obs_in_subgroup}{\link{integer} from=0. This optional argument specifies
the minimum number of observations that is required to
include a subgroup (level) of the \code{group_var} in the
analysis.}

\item{min_subgroups}{\link{integer} from=3. The model provided by the \code{ordinal}
package requires at least three different subgroups
(levels) of the \code{group_var}. Users might want to
increase this threshold to obtain results only for
variables with a sufficient number of \code{group_var}
levels (observers, devices, etc.).}

\item{ds1}{\link{data.frame} the data frame that contains the measurements, after
replacing missing value codes by \code{NA}, excluding
inadmissible values and transforming categorical
variables to factors.}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{adjusted_hint}{\link{character} hint, if adjusted for \code{co_vars}}

\item{title}{\link{character} title for the plot}

\item{sort_group_var_levels}{\link{logical} Should the levels of the grouping
variable be sorted descending by the number of
observations (in the figure)?}
}
\value{
A table and a matching plot.
}
\description{
This function is still under development. It uses the \code{ordinal} package to
compute ordered regression models.
}
