% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_delta_funs}
\alias{calc_delta_funs}
\title{Calculate delta function(s)}
\usage{
calc_delta_funs(
  quantiles_dat,
  minuends = NULL,
  subtrahends = NULL,
  dvs = NULL,
  b_coding
)
}
\arguments{
\item{quantiles_dat}{a data.frame of quantiles (\link{calc_quantiles})}

\item{minuends, subtrahends}{character vectors (with equal length), specifying
the conditions to use for the delta function: minuend - subtrahend}

\item{dvs}{character, indicating which quantile columns to use. Default
is "Quant_<u_label>". If multiple dvs are provided, then minuends and
subtrahends must have the same length, and matching occurs pairwise. In this
case, if only one minuend/subtrahend is specified, minuend and subtrahend are
recycled to the necessary length.}

\item{b_coding}{a \link{b_coding} object, necessary to build default
dvs}
}
\value{
a data.frame with columns "Source", "Prob", the "Quant_<u_label>",
"Quant_<l_label". May have the following additional columns:
\itemize{
\item if only one dv: as many Delta_<minuend_subtrahend> and
Avg_<minuends_subtrahends> as minuends and subtrahends.
\item if more than one dv: as many Delta_<u/l-label>\emph{<minuend_subtrahend> and
Avg}<u/l-label>_<minuends_subtrahends> as minuends and subtrahends.
}

The data.frame is of type
c("delta_funs", "sum_dist", "stats_dm", "data.frame")
}
\description{
Given a dataset providing the quantiles (\link{calc_quantiles}),
calculates delta function(s) for the character vectors minuends and
subtrahends
}
\details{
Takes the quantile data_frame, \link[stats:reshape]{stats::reshape} it to wide, and then
access the relevant \code{dv} columns, together with minuends and subtrahends
to calculate the delta functions.
}
\seealso{
\code{\link[=new_stats_dm]{new_stats_dm()}}
}
\keyword{internal}
