% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_df}
\alias{validate_df}
\title{Validate Argument df}
\usage{
validate_df(df = NULL, quiet = FALSE)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
data frame
}
\description{
Internal function to validate the argument \code{df} and ensure it complies with the requirements of the package functions. It performs the following actions:
\itemize{
\item Stops if 'df' is NULL.
\item Stops if 'df' cannot be coerced to data frame.
\item Stops if 'df' has zero rows.
\item Removes geometry column if the input data frame is an "sf" object.
\item Removes non-numeric columns with as many unique values as rows df has.
\item Converts logical columns to numeric.
\item Converts factor and ordered columns to character.
\item Tags the data frame with the attribute \code{validated = TRUE} to let the package functions skip the data validation.
}
}
\examples{

data(vi)

#validating example data frame
vi <- validate_df(
  df = vi
)

#tagged as validated
attributes(vi)$validated
}
\seealso{
Other data_validation: 
\code{\link{validate_data_cor}()},
\code{\link{validate_data_vif}()},
\code{\link{validate_encoding_arguments}()},
\code{\link{validate_predictors}()},
\code{\link{validate_preference_order}()},
\code{\link{validate_response}()}
}
\concept{data_validation}
