% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-docs.R
\name{btw_tool_package_docs}
\alias{btw_tool_package_docs}
\alias{btw_tool_docs_package_help_topics}
\alias{btw_tool_docs_help_page}
\alias{btw_tool_docs_available_vignettes}
\alias{btw_tool_docs_vignette}
\title{Tool: Describe R package documentation}
\usage{
btw_tool_docs_package_help_topics(package_name, `_intent` = "")

btw_tool_docs_help_page(topic, package_name = "", `_intent` = "")

btw_tool_docs_available_vignettes(package_name, `_intent` = "")

btw_tool_docs_vignette(package_name, vignette = package_name, `_intent` = "")
}
\arguments{
\item{package_name}{The name of the package as a string, e.g. \code{"shiny"}.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}

\item{topic}{The \code{topic_id} or \code{alias} of the help page, e.g.
\code{"withProgress"} or \code{"incProgress"}. Find \code{topic_id}s or \code{alias}es using
\code{get_package_help()}.}

\item{vignette}{The name (or index) of the vignette to
retrieve. Defaults to the "intro" vignette to the package (by the same
rules as pkgdown.)}
}
\value{
\itemize{
\item \code{btw_tool_docs_package_help_topics()} returns the \code{topic_id}, \code{title}, and
\code{aliases} fields for every topic in a package's documentation as a
json-formatted string.
\item \code{btw_tool_docs_help_page()} returns the help-page for a package topic as a
string.
}
}
\description{
These functions describe package documentation in plain text.
\subsection{Additional Examples}{

Show a list of available vignettes in the \code{dplyr} package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{btw_tool_docs_available_vignettes("dplyr")
}\if{html}{\out{</div>}}

Get the introductory vignette for the \code{dplyr} package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{btw_tool_docs_vignette("dplyr")
}\if{html}{\out{</div>}}

Get a specific vignette, such as the programming vignette for the \code{dplyr}
package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{btw_tool_docs_vignette("dplyr", "programming")
}\if{html}{\out{</div>}}
}
}
\examples{
\dontshow{if (rmarkdown::pandoc_available()) withAutoprint(\{ # examplesIf}
btw_tool_docs_package_help_topics("btw")

btw_tool_docs_help_page("btw", "btw")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=btw_tools]{btw_tools()}}

Other Tools: 
\code{\link{btw_tool_docs_package_news}()},
\code{\link{btw_tool_env_describe_data_frame}()},
\code{\link{btw_tool_env_describe_environment}()},
\code{\link{btw_tool_files_code_search}()},
\code{\link{btw_tool_files_list_files}()},
\code{\link{btw_tool_files_read_text_file}()},
\code{\link{btw_tool_files_write_text_file}()},
\code{\link{btw_tool_ide_read_current_editor}()},
\code{\link{btw_tool_search_packages}()},
\code{\link{btw_tool_session_package_info}()},
\code{\link{btw_tool_session_platform_info}()},
\code{\link{btw_tool_web_read_url}()},
\code{\link{btw_tools}()}
}
\concept{Tools}
