## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(boostmath)

## -----------------------------------------------------------------------------
arcsine_pdf(0.5)
arcsine_lpdf(0.5)
arcsine_cdf(0.5)
arcsine_lcdf(0.5)
arcsine_quantile(0.5)

## -----------------------------------------------------------------------------
bernoulli_pdf(1, 0.5)
bernoulli_lpdf(1, 0.5)
bernoulli_cdf(1, 0.5)
bernoulli_lcdf(1, 0.5)
bernoulli_quantile(0.5, 0.5)

## -----------------------------------------------------------------------------
# Beta distribution with shape parameters alpha = 2, beta = 5
beta_pdf(0.5, 2, 5)
beta_lpdf(0.5, 2, 5)
beta_cdf(0.5, 2, 5)
beta_lcdf(0.5, 2, 5)
beta_quantile(0.5, 2, 5)

## -----------------------------------------------------------------------------
# Binomial dist ribution with n = 10, prob = 0.5
binomial_pdf(3, 10, 0.5)
binomial_lpdf(3, 10, 0.5)
binomial_cdf(3, 10, 0.5)
binomial_lcdf(3, 10, 0.5)
binomial_quantile(0.5, 10, 0.5)

## -----------------------------------------------------------------------------
# Cauchy distribution with location = 0, scale = 1
cauchy_pdf(0)
cauchy_lpdf(0)
cauchy_cdf(0)
cauchy_lcdf(0)
cauchy_quantile(0.5)

## -----------------------------------------------------------------------------
# Chi-Squared distribution with 3 degrees of freedom
chi_squared_pdf(2, 3)
chi_squared_lpdf(2, 3)
chi_squared_cdf(2, 3)
chi_squared_lcdf(2, 3)
chi_squared_quantile(0.5, 3)

## -----------------------------------------------------------------------------
# Exponential distribution with rate parameter lambda = 2
exponential_pdf(1, 2)
exponential_lpdf(1, 2)
exponential_cdf(1, 2)
exponential_lcdf(1, 2)
exponential_quantile(0.5, 2)

## -----------------------------------------------------------------------------
# Extreme Value distribution with location = 0, scale = 1
extreme_value_pdf(0)
extreme_value_lpdf(0)
extreme_value_cdf(0)
extreme_value_lcdf(0)
extreme_value_quantile(0.5)

## -----------------------------------------------------------------------------
# Fisher F distribution with df1 = 5, df2 = 2
fisher_f_pdf(1, 5, 2)
fisher_f_lpdf(1, 5, 2)
fisher_f_cdf(1, 5, 2)
fisher_f_lcdf(1, 5, 2)
fisher_f_quantile(0.5, 5, 2)

## -----------------------------------------------------------------------------
# Gamma distribution with shape = 3, scale = 4
gamma_pdf(2, 3, 4)
gamma_lpdf(2, 3, 4)
gamma_cdf(2, 3, 4)
gamma_lcdf(2, 3, 4)
gamma_quantile(0.5, 3, 4)

## -----------------------------------------------------------------------------
# Geometric distribution with probability of success prob = 0.5
geometric_pdf(3, 0.5)
geometric_lpdf(3, 0.5)
geometric_cdf(3, 0.5)
geometric_lcdf(3, 0.5)
geometric_quantile(0.5, 0.5)

## -----------------------------------------------------------------------------
# Holtsmark distribution with location 0 and scale 1
holtsmark_pdf(3)
holtsmark_lpdf(3)
holtsmark_cdf(3)
holtsmark_lcdf(3)
holtsmark_quantile(0.5)

## -----------------------------------------------------------------------------
# Hyperexponential distribution with probabilities = c(0.5, 0.5) and rates = c(1, 2)
hyperexponential_pdf(2, c(0.5, 0.5), c(1, 2))
hyperexponential_lpdf(2, c(0.5, 0.5), c(1, 2))
hyperexponential_cdf(2, c(0.5, 0.5), c(1, 2))
hyperexponential_lcdf(2, c(0.5, 0.5), c(1, 2))
hyperexponential_quantile(0.5, c(0.5, 0.5), c(1, 2))

## -----------------------------------------------------------------------------
# Hypergeometric distribution with r = 5, n = 10, N = 20
hypergeometric_pdf(3, 5, 10, 20)
hypergeometric_lpdf(3, 5, 10, 20)
hypergeometric_cdf(3, 5, 10, 20)
hypergeometric_lcdf(3, 5, 10, 20)
hypergeometric_quantile(0.5, 5, 10, 20)

## -----------------------------------------------------------------------------
# Inverse Chi-Squared distribution with 3 degrees of freedom, scale = 1
inverse_chi_squared_pdf(2, 3, 1)
inverse_chi_squared_lpdf(2, 3, 1)
inverse_chi_squared_cdf(2, 3, 1)
inverse_chi_squared_lcdf(2, 3, 1)
inverse_chi_squared_quantile(0.5, 3, 1)

## -----------------------------------------------------------------------------
# Inverse Gamma distribution with shape = 3, scale = 4
inverse_gamma_pdf(2, 3, 4)
inverse_gamma_lpdf(2, 3, 4)
inverse_gamma_cdf(2, 3, 4)
inverse_gamma_lcdf(2, 3, 4)
inverse_gamma_quantile(0.5, 3, 4)

## -----------------------------------------------------------------------------
# Inverse Gaussian distribution with mu = 3, lambda = 4
inverse_gaussian_pdf(2, 3, 4)
inverse_gaussian_lpdf(2, 3, 4)
inverse_gaussian_cdf(2, 3, 4)
inverse_gaussian_lcdf(2, 3, 4)
inverse_gaussian_quantile(0.5, 3, 4)

## -----------------------------------------------------------------------------
# Kolmogorov-Smirnov distribution with sample size n = 10
kolmogorov_smirnov_pdf(0.5, 10)
kolmogorov_smirnov_lpdf(0.5, 10)
kolmogorov_smirnov_cdf(0.5, 10)
kolmogorov_smirnov_lcdf(0.5, 10)
kolmogorov_smirnov_quantile(0.5, 10)

## -----------------------------------------------------------------------------
# Landau distribution with location 0 and scale 1
landau_pdf(3)
landau_lpdf(3)
landau_cdf(3)
landau_lcdf(3)
landau_quantile(0.5)

## -----------------------------------------------------------------------------
# Laplace distribution with location = 0, scale = 1
laplace_pdf(0)
laplace_lpdf(0)
laplace_cdf(0)
laplace_lcdf(0)
laplace_quantile(0.5)

## -----------------------------------------------------------------------------
# Logistic distribution with location = 0, scale = 1
logistic_pdf(0)
logistic_lpdf(0)
logistic_cdf(0)
logistic_lcdf(0)
logistic_quantile(0.5)

## -----------------------------------------------------------------------------
# Log Normal distribution with location = 0, scale = 1
lognormal_pdf(0)
lognormal_lpdf(0)
lognormal_cdf(0)
lognormal_lcdf(0)
lognormal_quantile(0.5)

## -----------------------------------------------------------------------------
# Map-Airy distribution with location 0 and scale 1
mapairy_pdf(3)
mapairy_lpdf(3)
mapairy_cdf(3)
mapairy_lcdf(3)
mapairy_quantile(0.5)

## -----------------------------------------------------------------------------
negative_binomial_pdf(3, 5, 0.5)
negative_binomial_lpdf(3, 5, 0.5)
negative_binomial_cdf(3, 5, 0.5)
negative_binomial_lcdf(3, 5, 0.5)
negative_binomial_quantile(0.5, 5, 0.5)

## -----------------------------------------------------------------------------
# Noncentral Beta distribution with shape parameters alpha = 2, beta = 3
# and noncentrality parameter lambda = 1
non_central_beta_pdf(0.5, 2, 3, 1)
non_central_beta_lpdf(0.5, 2, 3, 1)
non_central_beta_cdf(0.5, 2, 3, 1)
non_central_beta_lcdf(0.5, 2, 3, 1)
non_central_beta_quantile(0.5, 2, 3, 1)

## -----------------------------------------------------------------------------
# Noncentral Chi-Squared distribution with 3 degrees of freedom and noncentrality
# parameter 1
non_central_chi_squared_pdf(2, 3, 1)
non_central_chi_squared_lpdf(2, 3, 1)
non_central_chi_squared_cdf(2, 3, 1)
non_central_chi_squared_lcdf(2, 3, 1)
non_central_chi_squared_quantile(0.5, 3, 1)

## -----------------------------------------------------------------------------
# Noncentral F distribution with df1 = 5, df2 = 2 and noncentrality
# parameter 1
non_central_f_pdf(1, 5, 2, 1)
non_central_f_lpdf(1, 5, 2, 1)
non_central_f_cdf(1, 5, 2, 1)
non_central_f_lcdf(1, 5, 2, 1)
non_central_f_quantile(0.5, 5, 2, 1)

## -----------------------------------------------------------------------------
# Noncentral T distribution with 3 degrees of freedom and noncentrality parameter 1
non_central_t_pdf(0, 3, 1)
non_central_t_lpdf(0, 3, 1)
non_central_t_cdf(0, 3, 1)
non_central_t_lcdf(0, 3, 1)
non_central_t_quantile(0.5, 3, 1)

## -----------------------------------------------------------------------------
# Normal distribution with mean = 0, sd = 1
normal_pdf(0)
normal_lpdf(0)
normal_cdf(0)
normal_lcdf(0)
normal_quantile(0.5)

## -----------------------------------------------------------------------------
# Pareto distribution with shape = 1, scale = 1
pareto_pdf(1)
pareto_lpdf(1)
pareto_cdf(1)
pareto_lcdf(1)
pareto_quantile(0.5)

## -----------------------------------------------------------------------------
# Poisson distribution with lambda = 1
poisson_pdf(0, 1)
poisson_lpdf(0, 1)
poisson_cdf(0, 1)
poisson_lcdf(0, 1)
poisson_quantile(0.5, 1)

## -----------------------------------------------------------------------------
# Rayleigh distribution with scale = 1
rayleigh_pdf(1)
rayleigh_lpdf(1)
rayleigh_cdf(1)
rayleigh_lcdf(1)
rayleigh_quantile(0.5)

## -----------------------------------------------------------------------------
# SaS Point5 distribution with location 0 and scale 1
saspoint5_pdf(3)
saspoint5_lpdf(3)
saspoint5_cdf(3)
saspoint5_lcdf(3)
saspoint5_quantile(0.5)

## -----------------------------------------------------------------------------
# Skew Normal distribution with location = 0, scale = 1, shape = 0
skew_normal_pdf(0)
skew_normal_lpdf(0)
skew_normal_cdf(0)
skew_normal_lcdf(0)
skew_normal_quantile(0.5)

## -----------------------------------------------------------------------------
# Student's t distribution with 3 degrees of freedom
students_t_pdf(0, 3)
students_t_lpdf(0, 3)
students_t_cdf(0, 3)
students_t_lcdf(0, 3)
students_t_quantile(0.5, 3)

## -----------------------------------------------------------------------------
# Triangular distribution with lower = 0, mode = 1, upper = 2
triangular_pdf(1)
triangular_lpdf(1)
triangular_cdf(1)
triangular_lcdf(1)
triangular_quantile(0.5)

## -----------------------------------------------------------------------------
# Uniform distribution with lower = 0, upper = 1
uniform_pdf(0.5)
uniform_lpdf(0.5)
uniform_cdf(0.5)
uniform_lcdf(0.5)
uniform_quantile(0.5)

## -----------------------------------------------------------------------------
# Weibull distribution with shape = 1, scale = 1
weibull_pdf(1)
weibull_lpdf(1)
weibull_cdf(1)
weibull_lcdf(1)
weibull_quantile(0.5)

