% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaMethod-delta-generic.R
\name{DeltaGeneric}
\alias{DeltaGeneric}
\title{Delta Method (Generic Object Input)}
\usage{
DeltaGeneric(
  object,
  def,
  theta = 0,
  alpha = c(0.05, 0.01, 0.001),
  z = TRUE,
  df = NULL
)
}
\arguments{
\item{object}{R object.
Fitted model object with \code{coef} and \code{vcov} methods
that return a named vector of
estimated parameters and sampling variance-covariance matrix,
respectively.}

\item{def}{List of character strings.
A list of defined functions of parameters.
The string should be a valid R expression when parsed
and should result a single value when evaluated.}

\item{theta}{Numeric vector.
Parameter values when the null hypothesis is true.}

\item{alpha}{Numeric vector.
Significance level/s.}

\item{z}{Logical.
If \code{z = TRUE},
use the standard normal distribution.
If \code{z = FALSE},
use the t distribution.}

\item{df}{Numeric.
Degrees of freedom if \code{z = FALSE}.}
}
\value{
Returns an object
of class \code{deltamethod} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{coef}{Estimates.}
\item{vcov}{Sampling variance-covariance matrix.}
\item{jacobian}{Jacobian matrix.}
\item{fun}{Function used ("DeltaGeneric").}
}
}
\description{
Calculates delta method sampling variance-covariance matrix
for a function of parameters
using a numerical Jacobian.
}
\examples{
object <- glm(
  formula = vs ~ wt + disp,
  family = "binomial",
  data = mtcars
)
def <- list("exp(wt)", "exp(disp)")
DeltaGeneric(
  object = object,
  def = def,
  alpha = 0.05
)
}
\seealso{
Other Delta Method Functions: 
\code{\link{Delta}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Delta Method Functions}
\keyword{deltaMethod}
