% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_cppglobal}
\alias{setup_cppglobal}
\title{Setup Global Calibrated Power Prior Design Object}
\usage{
setup_cppglobal(k, p0, shape1 = 1, shape2 = 1)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{shape1}{First common shape parameter of the beta prior.}

\item{shape2}{Second common shape parameter of the beta prior.}
}
\value{
An S3 object of class \code{cppglobal}
}
\description{
Setup Global Calibrated Power Prior Design Object
}
\details{
The class \code{cppglobal} implements a version of the power prior
design, in which the amount of information that is shared between baskets is
determined by the Kolmogorov-Smirnov test statistic between basekts and
a function based on response rate differences that quantifies the
overall heterogeneity.
}
\examples{
design_cppglobal <- setup_cppglobal(k = 3, p0 = 0.2)
}
\references{
Baumann, L., Sauer, L., & Kieser, M. (2024). A basket trial
design based on power priors. arXiv:2309.06988.
}
