% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_data}
\alias{download_data}
\title{Load base-rate database, model typicality matrices, or human validation ratings}
\usage{
download_data(
  which = c("database", "validation_ratings", "typicality_matrix_gpt4",
    "typicality_matrix_llama3.3", "material"),
  dest = NULL
)
}
\arguments{
\item{which}{One of "database", "validation_ratings", "typicality_matrix_gpt4", "typicality_matrix_llama3.3", or "material".}

\item{dest}{Optional path to copy the file to (returns the data either way).}
}
\value{
A tibble with the requested data.
}
\description{
This function gives access to key datasets included in the \code{baserater} package.
}
\details{
\itemize{
\item The \code{"database"} object includes all base-rate items along with stereotype strength estimates from 'GPT-4' and 'LLaMA 3.3'.
\item The \code{"validation_ratings"} object contains average typicality judgments from 50 human participants on 100 group–adjective pairs, as well as ratings from 'GPT-4' and 'LLaMA 3.3'.
\item The \code{"typicality_matrix_gpt4"} and \code{"typicality_matrix_llama3.3"} objects are raw typicality matrices generated by each model.
\item The \code{"material"} object contains the lists of individual groups and adjectives used to build the base-rate database.
}
}
\examples{

database <- download_data("database")

ratings <- download_data("validation_ratings")

gpt4_matrix <- download_data("typicality_matrix_gpt4")

llama3_matrix <- download_data("typicality_matrix_llama3.3")

material <- download_data("material")
}
