% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrn.R
\name{psrn}
\alias{psrn}
\title{Normalize data to a pseudo-reference}
\source{
\url{https://www.nature.com/articles/npre.2010.4282.1}
}
\usage{
psrn(data, id_col, log = TRUE, load_info = FALSE, target = NULL)
}
\arguments{
\item{data}{data.frame}

\item{id_col}{a character for the name of the column containing the
name of the features in data (e.g., peptides, proteins, etc.)}

\item{log}{boolean variable indicating if the data should be log transformed
after normalization}

\item{load_info}{logical; should the load information be output?}

\item{target}{target columns to normalize, supports
\code{\link[tidyselect]{tidyselect-package}} syntax. By default, all numerical
columns will be used in the normalization if not specified.}
}
\value{
data frame with normalized values if \code{load_info=FALSE}, if it is \code{TRUE}
then it returns a list with two tibbles. One tibble containing the
normalized data and one containing the loading info as well as the
estimated normalization factors.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function generates a pseudo-reference by taking the geometric mean of
each peptide across all samples. Each peptide in each sample is then divided
by the pseudo-reference. Then, the median ratio of all ratios is used as an
estimate to use for normalizing differences in loading concentration. All
features in each sample is then divided by their corresponding estimate.
All estimates are based on features without missing values.
For details see \insertCite{anders2010differential;textual}{baldur}.
}
\examples{
yeast_psrn <- psrn(yeast, "identifier")
yeast_psrn_with_load <- psrn(yeast, "identifier", load_info = TRUE)
yeast_ng50_only <- psrn(yeast, "identifier", target = matches('ng50'))
}
\references{
\insertAllCited{}
}
