% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{fit.bage_mod}
\alias{fit.bage_mod}
\title{Fit a Model}
\usage{
\method{fit}{bage_mod}(
  object,
  method = c("standard", "inner-outer"),
  vars_inner = NULL,
  optimizer = c("multi", "nlminb", "BFGS", "CG"),
  quiet = TRUE,
  start_oldpar = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{bage_mod} object,
created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{method}{Estimation method. Current
choices are \code{"standard"} (the default)
and \code{"inner-outer"}.
See below for details.}

\item{vars_inner}{Names of variables to use
for inner model when \code{method} is \verb{"inner-outer". If }NULL\verb{(the default)}vars_inner` is the
\link[=set_var_age]{age}, \link[=set_var_sexgender]{sex/gender},
and \link[=set_var_time]{time} variables.}

\item{optimizer}{Which optimizer to use.
Current choices are \code{"multi"},
\code{"nlminb"}, \code{"BFGS"}, and \code{"CG"}. Default
is \code{"multi"}. See below for details.}

\item{quiet}{Whether to suppress messages.
Default is \code{TRUE}.}

\item{start_oldpar}{Whether the optimizer should start
at previous estimates. Used only
when \code{fit()} is being called on a fitted
model. Default is \code{FALSE}.}

\item{...}{Not currently used.}
}
\value{
A \code{bage_mod} object
}
\description{
Derive the posterior distribution
for a model.
}
\section{Estimation methods}{


When \code{method} is \code{"standard"} (the default),
all parameters, other than
the lowest-level rates, probabilities, or
means are jointly estimated within TMB.

When \code{method} is \code{"inner-outer"}, estimation is
carried out in multiple steps, which, in large models,
can sometimes reduce computation times.
In Step 1, the data is aggregated across all dimensions other
than those specified in \code{var_inner}, and a model
for the \code{inner} variables is fitted to the data.
In Step 2, the data is aggregated across the
remaining variables, and a model for the
\code{outer} variables is fitted to the data.
In Step 3, values for dispersion are calculated.
Parameter estimates from steps 1, 2, and 3
are then combined. \code{"inner-outer"} methods are
still experimental, and may change in future.
}

\section{Optimizer}{


The choices for the \code{optimizer} argument are:
\itemize{
\item \code{"multi"} Try \code{"nlminb"}, and if that fails,
restart from the parameter values where \code{"nlminb"} stopped,
using \code{"BFGS"}. The default.
\item \code{"nlminb"} \code{\link[stats:nlminb]{stats::nlminb()}}
\item \code{"BFGS"} \code{\link[stats:optim]{stats::optim()}} using method \code{"BFGS"}.
\item \code{"GC"} \code{\link[stats:optim]{stats::optim()}} using method \code{"CG"} (conjugate gradient).
}
}

\examples{
## specify model
mod <- mod_pois(injuries ~ age + sex + year,
                data = nzl_injuries,
                exposure = popn)

## examine unfitted model
mod

## fit model
mod <- fit(mod)

## examine fitted model
mod

## extract rates
aug <- augment(mod)
aug

## extract hyper-parameters
comp <- components(mod)
comp
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=mod_binom]{mod_binom()}} Specify a binomial model
\item \code{\link[=mod_norm]{mod_norm()}} Specify a normal model
\item \code{\link[=augment]{augment()}} Extract values for rates,
probabilities, or means, together
with original data
\item \code{\link[=components]{components()}} Extract values for hyper-parameters
\item \code{\link[=forecast]{forecast()}} Forecast, based on a model
\item \code{\link[=report_sim]{report_sim()}} Simulation study of a model
\item \code{\link[=unfit]{unfit()}} Reset a model
\item \code{\link[=is_fitted]{is_fitted()}} Check if a model has been fitted
\item \href{https://bayesiandemography.github.io/bage/articles/vig02_math.html}{Mathematical Details}
vignette
}
}
