% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbt.pred.R
\name{predict.Rcpp_ENSEMBLE}
\alias{predict.Rcpp_ENSEMBLE}
\title{aGTBoost Prediction}
\usage{
\method{predict}{Rcpp_ENSEMBLE}(object, newdata, ...)
}
\arguments{
\item{object}{Object or pointer to object of class \code{ENSEMBLE}}

\item{newdata}{Design matrix of data to be predicted. Type \code{matrix}}

\item{...}{additional parameters passed. Currently not in use.}
}
\value{
For regression or binary classification, it returns a vector of length \code{nrows(newdata)}.
}
\description{
\code{predict} is an interface for predicting from a \pkg{agtboost} model.
}
\details{
The prediction function for \pkg{agtboost}.
Using the generic \code{predict} function in R is also possible, using the same arguments.
}
\examples{
## A simple gtb.train example with linear regression:
x <- runif(500, 0, 4)
y <- rnorm(500, x, 1)
x.test <- runif(500, 0, 4)
y.test <- rnorm(500, x.test, 1)

mod <- gbt.train(y, as.matrix(x))

## predict is overloaded
y.pred <- predict( mod, as.matrix( x.test ) )

plot(x.test, y.test)
points(x.test, y.pred, col="red")


}
\references{
Berent Ånund Strømnes Lunde, Tore Selland Kleppe and Hans Julius Skaug,
"An Information Criterion for Automatic Gradient Tree Boosting", 2020, 
\url{https://arxiv.org/abs/2008.05926}
}
\seealso{
\code{\link{gbt.train}}
}
