% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetUpdatedPropertyDetails.R
\name{GetUpdatedPropertyDetails}
\alias{GetUpdatedPropertyDetails}
\title{Make request to Zillow API GetUpdatedPropertyDetails Web Service}
\usage{
GetUpdatedPropertyDetails(
  zpid = NULL,
  zws_id = getOption("ZillowR-zws_id"),
  url = "http://www.zillow.com/webservice/GetUpdatedPropertyDetails.htm"
)
}
\arguments{
\item{zpid}{The Zillow Property ID for the property for which to obtain
information. Required.}

\item{zws_id}{The Zillow Web Service Identifier. Required.}

\item{url}{URL for the GetUpdatedPropertyDetails Web Service. Required.}
}
\value{
A named list with the following elements:
\describe{
\item{\strong{request}}{a list with the request parameters}
\item{\strong{message}}{a list of status code(s) and message(s)
returned by the API}
\item{\strong{response}}{an XMLNode with the API-specific response
values. At this time, no further coercion is performed, so you
may have to use functions from the \code{XML} package to extract
the desired output.}
}
}
\description{
For a specified property, the GetUpdatedPropertyDetails API returns all of
the home facts that have been edited by the home's owner or agent. The result
set contains the following attributes:
}
\details{
\itemize{
\item Property address
\item Zillow property identifier
\item Posting details such as the agent name, MLS number, price, and
posting type (For Sale or Make Me Move(tm))
\item Up to five photos of the property
\item Updated home facts such as beds, baths, square footage, home
description, and neighborhood and school names
}
}
\examples{
\dontrun{
GetUpdatedPropertyDetails(zpid = 48749425)}
}
