% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrollment.R
\name{enrollment}
\alias{enrollment}
\title{Triggering condition by number of randomized patients}
\usage{
enrollment(n, ..., arms = NULL)
}
\arguments{
\item{n}{integer. Number of randomized patients.}

\item{...}{subset conditions compatible with \code{dplyr::filter}. Number
of randomized patients will be counted on subset of trial data only.}

\item{arms}{vector of character. Name of arms on which the number of patients
is counted. If \code{NULL}, use all arms that are not yet removed from the
trial by the time of calculation.}
}
\value{
an object of class `Condition`
}
\description{
Define a condition to trigger trial milestone by the number of randomized
patients. The milestone will be trigger when a trial has enrolled
at least the specified number of patients. It can be used combined with
conditions specified by \link[TrialSimulator]{calendarTime} and
\link[TrialSimulator]{eventNumber}.
}
