% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.pattern.R
\name{graph.pattern}
\alias{graph.pattern}
\title{Graph Pattern Visualization}
\usage{
graph.pattern(
  mat,
  main = NULL,
  edge.color = "gray50",
  vertex.color = "red",
  vertex.size = 3,
  vertex.label = NA,
  thres = 1e-05
)
}
\arguments{
\item{mat}{precision matrix that encodes information of graph struture.}

\item{main}{main title of graph. Default is \code{NULL}.}

\item{edge.color}{color of edge. Default is \code{"gray50"}.}

\item{vertex.color}{color of vertex. Default is \code{"red"}.}

\item{vertex.size}{size of vertex. Default is 3.}

\item{vertex.label}{label of vertex. Default is \code{NA}.}

\item{thres}{thresholding level of substituting entry with zero, 
set entry to zero if its absolute value equals or is less than \code{thres}. 
If \code{thres} is negative or zero, no entry will be substituted with zero.}
}
\value{
A plot of undirected graph.
}
\description{
Draw an undirected graph based on presicion matrix to present connection among variables.
}
\details{
This function generates an udirected graph based on precision matrix. 
If an entry is zero, then no edge connects corresponding pair of nodes.
}
\examples{
 
graph.pattern(ChainOmega(5, sd = 13))
# a triangle graph

}
\seealso{
\code{\link{infer.analysis}}, \code{\link{est.analysis}}
}
\author{
Xiang Lyu, Will Wei Sun, Zhaoran Wang, Han Liu, Jian Yang, Guang Cheng.
}
