% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.analysis.R
\name{est.analysis}
\alias{est.analysis}
\title{Estimation Errors and TPR/TNR}
\usage{
est.analysis(Omega.hat.list, Omega.true.list, offdiag = TRUE)
}
\arguments{
\item{Omega.hat.list}{list of estimation of precision matrices of tensor, i.e., \code{Omega.hat.list[[k]]} is estimation of precision matrix 
for the kth tensor mode, \eqn{k \in \{1 , \ldots, K\}}{ 1 <= k <= K }. For example, output of \code{\link{Tlasso.fit}}.}

\item{Omega.true.list}{list of true precision matrices of tensor, i.e., \code{Omega.true.list[[k]]} is true precision matrix 
for the kth tensor mode, \eqn{k \in \{1 , \ldots, K\}}{ 1 <= k <= K }.}

\item{offdiag}{logical; indicate if excludes diagnoal when computing performance measures. 
If \code{offdiag = TRUE}, diagnoal in each matrix is ingored 
when comparing two matrices. Default is \code{TRUE}.}
}
\value{
A list, named \code{Out}, of following performance measures:
\tabular{ll}{
\code{Out$error.kro}  \tab  error in Frobenius norm of kronecker product \cr
\code{Out$tpr.kro}  \tab   TPR of kronecker product \cr
\code{Out$tnr.kro}  \tab     TNR of kronecker product \cr
\code{Out$av.error.f}  \tab  averaged Frobenius norm error across all modes \cr
\code{Out$av.error.max}  \tab  averaged Max norm error across all modes \cr 
\code{Out$av.tpr}  \tab  averaged TPR across all modes \cr
\code{Out$av.tnr}  \tab  averaged TNR across all modes \cr
\code{Out$error.f}  \tab  vector; error in Frobenius norm of each mode  \cr
\code{Out$error.max}  \tab  vector; error in Max norm of each mode  \cr 
\code{Out$tpr}  \tab  vector; TPR of each mode \cr
\code{Out$tnr}  \tab   vector; TNR of each mode   \cr
}
}
\description{
Compute estimation errors and TPR/TNR of optimization for sparse tensor graphical models
}
\details{
This function computes performance measures of optimazation for sparse tensor graphical models. 
Errors are measured in Frobenius norm and Max norm. Model selection measures are TPR and TNR. All these measures are computed in each 
mode, average across all modes, and kronecker production of precision matrices.
}
\examples{

m.vec = c(5,5,5)  # dimensionality of a tensor 
n = 5   # sample size 
k=1 # index of interested mode
Omega.true.list = list()
Omega.true.list[[1]] = ChainOmega(m.vec[1], sd = 1)
Omega.true.list[[2]] = ChainOmega(m.vec[2], sd = 2)
Omega.true.list[[3]] = ChainOmega(m.vec[3], sd = 3)
lambda.thm = 20*c( sqrt(log(m.vec[1])/(n*prod(m.vec))), 
                   sqrt(log(m.vec[2])/(n*prod(m.vec))), 
                   sqrt(log(m.vec[3])/(n*prod(m.vec))))
DATA=Trnorm(n,m.vec,type='Chain') 
# obersavations from tensor normal distribution
out.tlasso = Tlasso.fit(DATA,T=1,lambda.vec = lambda.thm)   
# output is a list of estimation of precision matrices
est.analysis(out.tlasso, Omega.true.list, offdiag=TRUE)
# generate a list of performance measures

}
\seealso{
\code{\link{Tlasso.fit}}, \code{\link{NeighborOmega}}, \code{\link{ChainOmega}}
}
\author{
Xiang Lyu, Will Wei Sun, Zhaoran Wang, Han Liu, Jian Yang, Guang Cheng.
}
