% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_TAG.R
\name{TAG}
\alias{TAG}
\title{Transformed Additive Gaussian Process}
\usage{
TAG(iniTAG, HighD = FALSE, delta.threshold = -6)
}
\arguments{
\item{iniTAG}{object of class inheriting from "initial.TAG".}

\item{HighD}{logical. If TRUE, only  \eqn{\kappa} and delta will be estimated. This is useful for high dimensional data. Default is False.}

\item{delta.threshold}{the minimum value of log10(delta). Default is -6.}
}
\description{
This function fits the Transformed Additive Gaussian (TAG) process.
}
\details{
The details of the TAG process can be found in Lin and Joseph (2019).

When HighD = FALSE, the weight parameters, the length scale parameters, the nugget parameter, and the Box-Cox transformation parameter are estimated. When HighD = TRUE, the length scale parameters for TAG is  \eqn{\eta}*s0, where s0 is the initial estimate of the length scale parameters. Only  \eqn{\eta} and the nugget parameter are estimated.

}
\value{
The values returned from the function is a list containing the following components:
\item{omega}{The estimates of the weight parameters.}
\item{s}{The estimates of the length scale parameters.}
\item{lambda}{The estimate of the Box-Cox transformation parameter.}
\item{delta}{The estimate of the nugget parameter in log10 scale. For example, delta \eqn{= -6} means that the estimate of the nugget is \eqn{10^(-6)}.}
\item{kappa}{If HighD is true, an estimate of kappa will be returned, which is a multiplication factor for the initial estimates of the length scale parameters.}
\item{ty}{The transformed response vector.}
\item{X}{The n by p input design matrix.}
}
\references{
Lin, L.-H. and Joseph,  V. R. (2020) "Transformation and Additivity in Gaussian Processes",\emph{Technometrics}, 62, 525-535.  DOI:10.1080/00401706.2019.1665592.
}
\seealso{
  \code{\link{initial.TAG}} for finding the initial values for the parameters in a TAG process, and \code{\link{pred.TAG}} for prediction.
}
\examples{
n <- 20
p <- 2
library(randtoolbox)
X <-  sobol(n, dim = p, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
ini.TAG <- initial.TAG(y, X)
par.TAG <- TAG(ini.TAG)
}
\keyword{Estimated Parameters}
\keyword{TAG}
