% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Initial_TAG.R
\name{initial.TAG}
\alias{initial.TAG}
\title{Initial Values of TAG Process}
\usage{
initial.TAG(y, X, Candi.lambda = seq(from=-2, to=2,by=0.5),
            Adj.omega = TRUE, nug=0.001, nbasis=10, rannum=20, big=FALSE, nsub=31,
            method.1d = "DiceKriging")
}
\arguments{

\item{y}{a response vector of size n, where n is the sample size.}

\item{X}{an n by p design matrix, where n is the sample size, and p is the number of input variables.}

\item{Candi.lambda}{a vector containing the candidate values of the Box-Cox transformation parameter. Default is seq(from=-2, to=2,by=0.5).}

\item{Adj.omega}{logical. If TRUE, the initial estimates for weight parameters are adjusted to avoid 0. Default is TRUE.}

\item{nug}{a nonnegative value used as the nugget term for fitting the 1-dim GP models. Default is 0.001.}

\item{nbasis}{a positive integer specifying the basis dimension used in mgcv. Default is 10.}

\item{rannum}{a positive integer specifying the number of starting values in DiceKriging. Default is 2.}

\item{big}{logical. If TRUE, the bam function in the mgcv package is used; otherwise, the gam function is used. Default is FALSE.}

\item{nsub}{a positive integer specifying the number of design points used for obtaining the initial estimates of the length scale parameters. Default is 31.}

\item{method.1d}{the method used for fitting the 1-dimensional GPs. Currently, the method can be DiceKriging or mlegp.}
}
\description{
This function generates good initial values for the parameters in a TAG process.
}
\value{
The values returned from the function is a list containing the following components:
\item{omega}{The initial estimates of the weight parameters.}
\item{s}{The initial estimates of the length scale parameters.}
\item{lambda}{The initial estimate of the Box-Cox transformation parameter.}
\item{delta}{The initial estimate of the nugget parameter.}
\item{nbases}{The number of bases used in each dimension.}
\item{y}{The response vector.}
\item{X}{The n by p input design matrix.}
}
\references{
Lin, L.-H. and Joseph,  V. R. (2020) "Transformation and Additivity in Gaussian Processes",\emph{Technometrics}, 62, 525-535.  DOI:10.1080/00401706.2019.1665592.

Olivier Roustant, David Ginsbourger, Yves Deville (2012). DiceKriging, DiceOptim: Two R Packages for the Analysis of Computer Experiments by Kriging-Based Metamodeling and Optimization. Journal of Statistical Software, 51, 1-55.

Dancik, GM and Dorman, KS (2008). mlegp: Statistical analysis for computer models of biological systems using R. Bioinformatics 24, 1966-1967

Wood, S.N. (2017) Generalized Additive Models: An Introduction with R (2nd edition). New York: CRC press.


}
\examples{
n <- 20
p <- 2
library(randtoolbox)
X <-  sobol(n, dim = p, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
ini.TAG <- initial.TAG(y, X)


#An example for some inputs with fewer levels
n <- 18
p <- 2
X1 <- rep(c(0,1,2)/3, 6) # A factor with fewer levels
library(randtoolbox)
X2 <-  sobol(n, dim = 1, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
X <- cbind(X1, X2)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
ini.TAG <- initial.TAG(y, X)
}
\keyword{Initial Values}
\keyword{TAG}
