% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdeps.R
\name{pdeps}
\alias{pdeps}
\title{Dependencies of a Package}
\usage{
pdeps(packages, recursive = TRUE, reverse = FALSE, base = FALSE,
  installed = TRUE, available = TRUE, sort = FALSE, ...)
}
\arguments{
\item{packages}{package names.}

\item{recursive}{whether to include dependencies of dependencies.}

\item{reverse}{whether to find reverse dependencies instead.}

\item{base}{whether to include base packages.}

\item{installed}{whether to include installed packages.}

\item{available}{whether to include available packages.}

\item{sort}{whether to sort package dependencies.}

\item{\dots}{passed to \code{package_dependencies}.}
}
\value{
Names of packages that are required by \code{package}.
}
\description{
Find dependencies or reverse dependencies of a CRAN package.
}
\examples{
\dontrun{
# TAF dependencies
pdeps("TAF")                # does not depend on non-base packages
pdeps("TAF", base=TRUE)     # depends on these base packages
pdeps("TAF", reverse=TRUE)  # icesTAF depends on TAF

# Other packages with light dependencies
sapply(pdeps(c("data.table", "Rcpp", "renv")), length)

# ggplot2 dependencies
pdeps("ggplot2")                   # full list of dependencies
pdeps("ggplot2", recursive=FALSE)  # primary dependencies

# Each ggplot2 dependency brings in these secondary dependencies
pdeps(pdeps("ggplot2", recursive=FALSE)$ggplot2)
}

}
\seealso{
\code{\link{package_dependencies}} is the underlying base function to find
CRAN package dependencies.

\code{\link{installed.packages}}, \code{\link{available.packages}}.

\code{\link{deps}} shows the dependencies of a workflow.

\code{\link{TAF-package}} gives an overview of the package.
}
