% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddim.R
\name{ddim}
\alias{ddim}
\title{Data Dimensions}
\usage{
ddim(x, reduce = FALSE)
}
\arguments{
\item{x}{a data frame where the first columns are dimension variables and the
last column is a measurement variable.}

\item{reduce}{is whether to omit single-level dimensions.}
}
\value{
Named vector showing the dimension names and number of levels.
}
\description{
Show the data dimensions of a table.
}
\details{
Dimension variables can include year, age, region, fleet, survey, or the
like, generally an integer or string. The measurement variable can be catch,
fishing mortality, maturity, weight, or the like, often a decimal.

\code{x} can also be an FLR table in \code{FLQuant} format.
}
\examples{
# Long table format, 8 years and 4 ages
ddim(catage.long)

# Some base R datasets
ddim(esoph[-5])
ddim(rev(warpbreaks))
ddim(rev(ToothGrowth))

}
\seealso{
\code{\link{unique}} is the base function to extract the levels of a
dimension variable.

\code{\link{TAF-package}} gives an overview of the package.
}
