% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.svem_lasso.R
\name{predict.svem_model}
\alias{predict.svem_model}
\title{Predict Method for SVEM Models}
\usage{
\method{predict}{svem_model}(
  object,
  newdata,
  debias = FALSE,
  se.fit = FALSE,
  interval = FALSE,
  level = 0.95,
  agg = c("parms", "mean"),
  ...
)
}
\arguments{
\item{object}{An object of class svem_model (created by SVEMnet()).}

\item{newdata}{A data frame of new predictor values.}

\item{debias}{Logical; default is FALSE. If TRUE, apply the linear calibration
fit (y ~ y_pred) learned during training when available.}

\item{se.fit}{Logical; if TRUE, returns standard errors based on the bootstrap
spread when member predictions are available (default FALSE).}

\item{interval}{Logical; if TRUE, returns percentile confidence limits based
on bootstrap predictions when available (default FALSE).}

\item{level}{Confidence level for the percentile interval. Default 0.95.}

\item{agg}{Aggregation method for ensemble predictions. One of "parms" (default)
or "mean". "parms" uses the aggregated coefficients stored in object$parms
(or parms_debiased if debias=TRUE). "mean" averages predictions from individual
bootstrap members equally and optionally applies the debias calibration.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A numeric vector of predictions, or a list with components as follows:
\itemize{
\item fit: predictions
\item se.fit: bootstrap standard errors when se.fit = TRUE
\item lwr, upr: percentile confidence limits when interval = TRUE
}
}
\description{
Generates predictions from a fitted svem_model, with optional bootstrap
standard errors and percentile confidence intervals.
}
\details{
The function uses the training terms, factor levels (xlevels), and contrasts
saved by SVEMnet(). The terms object environment is set to baseenv() to avoid
unexpected lookup of objects in the original environment.

Column handling follows these rules:
\itemize{
\item The set of columns produced by model.matrix on newdata is aligned to those
used in training.
\item Any training columns dropped by model.matrix are added back as zeros.
\item Columns are reordered to the exact training order before multiplication.
}

Rows in newdata that contain unseen factor levels will yield NA predictions
(and NA standard errors and intervals if requested); a warning is issued indicating
how many rows were affected.

When agg = "mean", se.fit is the row-wise sd of member predictions. If debias = TRUE
and a finite calibration slope is available, both member predictions and their sd
are transformed by the calibration before aggregation. Percentile intervals are
computed from the transformed member predictions.
}
\examples{
set.seed(1)
n  <- 40
X1 <- rnorm(n); X2 <- rnorm(n); X3 <- rnorm(n)
y  <- 1 + 0.8*X1 - 0.5*X2 + 0.2*X3 + rnorm(n, 0, 0.3)
dat <- data.frame(y, X1, X2, X3)
fit <- SVEMnet(y ~ (X1 + X2 + X3)^2, dat, nBoot = 30, relaxed = TRUE)

# Mean aggregation with SEs and 95 percent CIs
out <- predict(fit, dat, debias = TRUE, se.fit = TRUE, interval = TRUE, agg = "mean")
str(out)

}
