% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DESeq2_l2fc.R
\name{DESeq2_l2fc}
\alias{DESeq2_l2fc}
\title{Calculating log2 fold change for HTS-SIP data.}
\usage{
DESeq2_l2fc(
  physeq,
  density_min,
  density_max,
  design,
  l2fc_threshold = 0.25,
  sparsity_threshold = 0.25,
  sparsity_apply = "all",
  size_factors = "geoMean"
)
}
\arguments{
\item{physeq}{Phyloseq object}

\item{density_min}{Minimum buoyant density of the 'heavy' gradient fractions}

\item{density_max}{Maximum buoyant density of the 'heavy' gradient fractions}

\item{design}{\code{design} parameter used for DESeq2 analysis.
See \code{DESeq2::DESeq} for more details.}

\item{l2fc_threshold}{log2 fold change (l2fc) values must be significantly above this
threshold in order to reject the hypothesis of equal counts.}

\item{sparsity_threshold}{All OTUs observed in less than this portion (fraction: 0-1)
of gradient fraction samples are pruned. A a form of indepedent filtering,
The sparsity cutoff with the most rejected hypotheses is used.}

\item{sparsity_apply}{Apply sparsity threshold to all gradient fraction samples ('all')
or just heavy fraction samples ('heavy')}

\item{size_factors}{Method of estimating size factors.
'geoMean' is from (Pepe-Ranney et. al., 2016) and removes all zero-abundances from the calculation.
'default' is the default for estimateSizeFactors.
'iterate' is an alternative when every OTU has a zero in >=1 sample.}
}
\value{
dataframe of HRSIP results
}
\description{
The 'use_geo_mean' parameter uses geometric means on all non-zero abundances
for estimateSizeFactors instead of using the default log-tranformed geometric means.
}
\examples{
data(phylo.qSIP)
\donttest{

df_l2fc = DESeq2_l2fc(phylo.qSIP, density_min=1.71, density_max=1.75, design=~Isotope)
}

}
