% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.shuffle.R
\name{SchaakeShuffleRef}
\alias{SchaakeShuffleRef}
\title{ShaakeShuffleRef class}
\description{
Match the rank structure of X with them of Y by reordering X.
}
\details{
Fix one features to keep the structure of X.
}
\examples{
X0 = matrix( stats::runif(20) , ncol = 2 )
Y0 = matrix( stats::runif(20) , ncol = 2 )
ss = SchaakeShuffleRef$new( ref = 1 )
ss$fit(Y0)
Z0 = ss$predict(X0)

}
\section{Super class}{
\code{\link[SBCK:SchaakeShuffle]{SBCK::SchaakeShuffle}} -> \code{SchaakeShuffleRef}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ref}}{[integer] Reference}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SchaakeShuffleRef-new}{\code{SchaakeShuffleRef$new()}}
\item \href{#method-SchaakeShuffleRef-fit}{\code{SchaakeShuffleRef$fit()}}
\item \href{#method-SchaakeShuffleRef-predict}{\code{SchaakeShuffleRef$predict()}}
\item \href{#method-SchaakeShuffleRef-clone}{\code{SchaakeShuffleRef$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SchaakeShuffleRef-new"></a>}}
\if{latex}{\out{\hypertarget{method-SchaakeShuffleRef-new}{}}}
\subsection{Method \code{new()}}{
Create a new ShaakeShuffleRef object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffleRef$new(ref, Y0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ref}}{[integer] Reference}

\item{\code{Y0}}{[vector] The reference vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `ShaaleShuffleRef` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SchaakeShuffleRef-fit"></a>}}
\if{latex}{\out{\hypertarget{method-SchaakeShuffleRef-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffleRef$fit(Y0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[vector] The reference vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SchaakeShuffleRef-predict"></a>}}
\if{latex}{\out{\hypertarget{method-SchaakeShuffleRef-predict}{}}}
\subsection{Method \code{predict()}}{
Fit the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffleRef$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{[vector] The vector to apply shuffle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Z0 [vector] data shuffled
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SchaakeShuffleRef-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SchaakeShuffleRef-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffleRef$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
