% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.abund.R
\name{summary.abund}
\alias{summary.abund}
\title{Summarize abundance estimates}
\usage{
\method{summary}{abund}(object, criterion = "AICc", ...)
}
\arguments{
\item{object}{An Rdistance model frame or fitted distance function,
normally produced by a call to \code{\link{dfuncEstim}}.}

\item{criterion}{A string specifying the model fit criterion to print.
Must be one of "AICc" (the default), 
"AIC", or "BIC".  See \code{\link{AIC.dfunc}} for formulas.}

\item{\dots}{Included for compatibility to other print methods.
Ignored here.}
}
\value{
0 is invisibly returned.
}
\description{
Summarize an object of class \code{c("abund","dfunc")} 
that is output by \code{abundEstim}.
}
\details{
If the proportion of bootstrap iterations that failed is 
greater than \code{getOption("Rdistance_maxBSFailPropForWarning")}, 
a warning about the validity of CI's is issued and 
a diagnostic message printed.  Increasing this option to a number greater 
than 1 will kill the warning (e.g., \code{options(Rdistance_maxBSFailPropForWarning = 1.3)}), 
but ignoring a large number of non-convergent
bootstrap iterations may be a bad idea (i.e., validity of the CI is 
questionable). The default value for \code{Rdistance_maxBSFailPropForWarning}
is 0.2.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowDf)

# Fit half-normal detection function
dfunc <- sparrowDf |> dfuncEstim(formula=dist ~ 1 + offset(groupsize))

# Estimate abundance given the detection function
fit <- abundEstim(dfunc
                , area = units::set_units(4105, "km^2")
                , ci=NULL)
summary(fit) # No confidence intervals
                
\dontrun{
# With bootstrap confidence intervals 
# Requires ~3 min to complete
fit <- abundEstim(dfunc
                , area = units::set_units(4105, "km^2")
                , ci=0.95)

summary(fit)
}
}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{abundEstim}}, 
\code{\link{summary.dfunc}}, \code{\link{print.dfunc}}, 
\code{\link{print.abund}}
}
\keyword{models}
