% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_MVP.R
\name{do.mvp}
\alias{do.mvp}
\title{Maximum Variance Projection}
\usage{
do.mvp(X, label, ndim = 2)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Maximum Variance Projection (MVP) is a supervised method based on linear discriminant analysis (LDA).
In addition to classical LDA, it further aims at preserving local information by capturing
the local geometry of the manifold via the following proximity coding,
\deqn{S_{ij} = 1\quad\textrm{if}\quad C_i \ne C_j\quad\textrm{and} = 0 \quad\textrm{otherwise}},
where \eqn{C_i} is the label of an \eqn{i}-th data point.
}
\examples{
\donttest{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150, 50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## perform MVP and compare with others
outMVP = do.mvp(X, label)
outPCA = do.pca(X)
outLDA = do.lda(X, label)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(outMVP$Y, col=label, pch=19, main="MVP")
plot(outPCA$Y, col=label, pch=19, main="PCA")
plot(outLDA$Y, col=label, pch=19, main="LDA")
par(opar)
}

}
\references{
\insertRef{zhang_maximum_2007}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
