% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pathway.R
\name{plot_pathway}
\alias{plot_pathway}
\title{Pathway analysis and visualization}
\usage{
plot_pathway(
  data = ~df,
  comp.names = NULL,
  gene.id.type = "ENSEMBL",
  FC.cutoff = 1.2,
  FDR.cutoff = 0.05,
  FCflag = "logFC",
  FDRflag = "adj.P.Val",
  Fisher.cutoff = 0.1,
  Fisher.up.cutoff = 0.1,
  Fisher.down.cutoff = 0.1,
  plot.save.to = NULL,
  pathway.db = "rWikiPathways",
  customized.pathways = NULL,
  ...
)
}
\arguments{
\item{data}{A summary statistics table (data.frame) or \code{data.list} generated by DE analysis software like limma or DEseq2, where rownames are gene id.}

\item{comp.names}{A character vector containing the comparison names corresponding to the same order of the \code{data.list}. Default = NULL.}

\item{gene.id.type}{The gene id format in \code{data} should be one of: ACCNUM, ALIAS, ENSEMBL, ENSEMBLPROT,
ENSEMBLTRANS, ENTREZID, ENZYME, EVIDENCE, EVIDENCEALL, GENENAME, GO, GOALL, IPI, MAP, OMIM,
ONTOLOGY, ONTOLOGYALL, PATH, PFAM, PMID, PROSITE, REFSEQ, SYMBOL, UCSCKG, UNIGENE, UNIPROT.}

\item{FC.cutoff}{The fold change cutoff (numeric) selected to subset summary statistics table. Default = 1.5.}

\item{FDR.cutoff}{The FDR cutoff selected (numeric) to subset summary statistics table. Default = 0.05.}

\item{FCflag}{The column name (character) of fold change information, assuming the FC is log2 transformed. Default = "logFC".}

\item{FDRflag}{The column name (character) of adjusted p value or FDR. Default = "adj.P.Val".}

\item{Fisher.cutoff}{The FDR cutoff selected (numeric) for the pathway enrichment analysis' Fisher's exact test with all determined
Differentially Expressed (DE) genes by \code{FC.cutoff} and \code{FDR.cutoff}.}

\item{Fisher.up.cutoff}{The FDR cutoff selected (numeric) for the pathway enrichment analysis' Fisher's exact test with the upregulated gene set.}

\item{Fisher.down.cutoff}{The FDR cutoff selected (numeric) for the pathway enrichment analysis' Fisher's exact test with the downregulated gene set.}

\item{plot.save.to}{The address to save the plot from simplified cutoff combination with FDR of 0.01, 0.05, 0.1, and 0.2.}

\item{pathway.db}{The databse to be used for encrichment analysis. Can be one of the following, "rWikiPathways", "KEGG", "REACTOME", "Hallmark","rWikiPathways_aug_2020".}

\item{customized.pathways}{the customized pathways in the format of two column dataframe (column name as "gs_name" and "entrez_gene") to be used in analysis.}

\item{...}{pass on variables}
}
\value{
The function returns a list of 5 objects:
\item{1}{result table from directional pathway enrichment analysis}
\item{2}{result table from non-directional pathway enrichment analysis}
\item{3}{plot from directional pathway enrichment analysis}
\item{4}{plot from non-directional pathway enrichment analysis}
\item{5}{plot combining both directional and non-directional plot}
}
\description{
This is the function to do pathway enrichment analysis (and visualization) with rWikipathways (also KEGG, REACTOME & Hallmark) from a summary statistics table generated by
differential expression analysis like \code{limma} or \code{DESeq2}.
}
\details{
The function takes the summary statistics table and use user selected parameter based on check.cutoff to do pathway enrichment analysis
}
\examples{
result <- plot_pathway(data = Sample_summary_statistics_table,
gene.id.type = "ENSEMBL",
FC.cutoff = 1.5,
p.cutoff = 0.05,
pathway.db = "rWikiPathways_aug_2020"
)
}
\references{
Xingpeng Li & Siddhartha Pachhai RVA - RNAseq Visualization Automation tool.
}
