% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_start_write_vector}
\alias{mvl_start_write_vector}
\alias{mvl_rewrite_vector}
\title{Piecewise output of very long numeric and integer vectors}
\usage{
mvl_start_write_vector(MVLHANDLE, x, expected.length = NULL, name = NULL)

mvl_rewrite_vector(obj, offset, x)
}
\arguments{
\item{MVLHANDLE}{handle to opened MVL file as generated by mvl_open()}

\item{x}{an integer or numeric vector}

\item{expected.length}{the length of vector to create. Use double to pass large values}

\item{name}{if specified add a named entry to MVL file directory}

\item{obj}{an MVL vector object to modify}

\item{offset}{the offset into MVL vector (starting with 1) to write x}
}
\description{
While \code{mvl_fused_write_objects} can be used to create very large vectors and data frames of arbitrary type, it requires
piecewise data to be written first into an MVL file. Functions \code{mvl_start_write_vector()} and \code{mvl_rewrite_vector()} provide a way to create very long vectors in one pass.
Only numeric and integer vectors are supported.
}
\details{
One convenient use is to compute \code{f(x,y,z,...)} with very long vector arguments by iterating over indices. The iteration can be done using fixed blocks of indices, or by using groups of indices computed with other MVL functions. 

It is generally recommended to call \code{mvl_rewrite_vector()} with large blocks to improve I/O performance and reduce number of writes to underlying media.
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
offset<-mvl_start_write_object(Mtmp, runif(10), expected.length=1000, "vec1")
Mtmp<-mvl_remap(Mtmp)
mvl_rewrite_vector(Mtmp[offset], 50, rnorm(20))
}


}
\seealso{
mvl_fused_write_objects
}
