% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{switch_weights}
\alias{switch_weights}
\title{Switch Between Weighting Schemes}
\usage{
switch_weights(weights_a, weights_b, use_b_condition, partial_blend = 1)
}
\arguments{
\item{weights_a}{Primary weight matrix}

\item{weights_b}{Alternative weight matrix}

\item{use_b_condition}{Logical vector (TRUE = use weights_b)}

\item{partial_blend}{Blend factor 0-1 (default: 1 = full switch)}
}
\value{
Combined weight matrix
}
\description{
Dynamically switches between two weighting schemes based on a signal.
Enables tactical allocation changes.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 10)
weights_equal <- weight_equally(selected)
weights_signal <- weight_by_signal(selected, momentum)

# Create switching signal (example: use SPY momentum as regime indicator)
spy_momentum <- momentum$SPY
switch_signal <- as.numeric(spy_momentum > median(spy_momentum, na.rm = TRUE))
switch_signal[is.na(switch_signal)] <- 0

# Switch between strategies
final_weights <- switch_weights(weights_equal, weights_signal, switch_signal)
}
