% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureEngineering.R
\name{robustNormalize}
\alias{robustNormalize}
\title{A function that normalizes continous by the interquartile range and
optionally forces the resulting values to be between -3 and 3 with
f(x) = x / sqrt(1 + (x/3)^2)
'@details uses (value - median) / iqr to normalize the data and then can
applies the function f(x) = x / sqrt(1 + (x/3)^2) to the normalized values.
This forces the values to be between -3 and 3 while preserving the relative
ordering of the values.
based on https://arxiv.org/abs/2407.04491 for more details}
\usage{
robustNormalize(trainData, featureEngineeringSettings, done = FALSE)
}
\arguments{
\item{trainData}{The training data to be normalized}

\item{featureEngineeringSettings}{The settings for the normalization}

\item{done}{Whether the data has already been normalized (bool)}
}
\value{
The \code{trainData} object with normalized data
}
\description{
A function that normalizes continous by the interquartile range and
optionally forces the resulting values to be between -3 and 3 with
f(x) = x / sqrt(1 + (x/3)^2)
'@details uses (value - median) / iqr to normalize the data and then can
applies the function f(x) = x / sqrt(1 + (x/3)^2) to the normalized values.
This forces the values to be between -3 and 3 while preserving the relative
ordering of the values.
based on https://arxiv.org/abs/2407.04491 for more details
}
\keyword{internal}
