% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{getResultsTable}
\alias{getResultsTable}
\title{Get results table from a study}
\usage{
getResultsTable(
  study,
  modelID,
  testID,
  annotationID = NULL,
  termID = NULL,
  libraries = NULL
)
}
\arguments{
\item{study}{An OmicNavigator study. Either an object of class \code{onStudy},
or the name of an installed study package.}

\item{modelID}{Filter by modelID}

\item{testID}{Filter by testID}

\item{annotationID}{Filter by annotationID}

\item{termID}{Filter by termID}

\item{libraries}{The directories to search for installed study packages. If
left as \code{NULL} (the default), then
\code{\link[utils]{installed.packages}} will use the result of
\code{\link{.libPaths}}.}
}
\value{
A data frame which includes the columns from the features table
followed by the columns from the results table. All the columns from the
features table will be character strings, even if the values appear
numeric.

If the optional arguments \code{annotationID} and \code{termID} are
provided, the table will be filtered to only include features in that
annotation term.
}
\description{
Get results table from a study
}
