% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LabFac.R
\name{LabFac}
\alias{LabFac}
\title{Generates the labels factors}
\usage{
LabFac(N, DomVar, GlobalVar, Economies, ModelType)
}
\arguments{
\item{N}{Integer. Number of country-specific spanned factors.}

\item{DomVar}{A character vector containing the names of the domestic variables.}

\item{GlobalVar}{A character vector containing the names of the global variables.}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{ModelType}{A character vector indicating the model type to be estimated.}
}
\value{
List containing the risk factor labels
}
\description{
Generates the labels factors
}
\examples{
N <- 2
DomVar <- c("inflation", "Output gap")
GlobalVar <- "Commodity Prices"
Economies <- c("U.S.", "Canada", "Germany", "Japan")
ModelType <- "JPS original"

VarLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)

}
