% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R, R/RLum.Data-class.R, R/RLum.Results-class.R,
%   R/Risoe.BINfileData-class.R
\name{view}
\alias{view}
\alias{view,RLum.Analysis-method}
\alias{view,RLum.Data-method}
\alias{view,RLum.Results-method}
\alias{view,Risoe.BINfileData-method}
\title{Convenience data visualisation function}
\usage{
view(object, ...)

\S4method{view}{RLum.Analysis}(object, ...)

\S4method{view}{RLum.Data}(object, ...)

\S4method{view}{RLum.Results}(object, element = 1, ...)

\S4method{view}{Risoe.BINfileData}(object, ...)
}
\arguments{
\item{object}{(\strong{required}) object to view}

\item{...}{further arguments passed to the specific class method}

\item{element}{\link{integer} (\emph{with default}):
index of the element to display.}
}
\value{
\code{NULL} and opens the data viewer.
}
\description{
Invokes the \link[utils:View]{utils::View} function tailored to objects in the package.
If started from RStudio, it uses the RStudio viewer.
}
\section{Functions}{
\itemize{
\item \code{view(RLum.Analysis)}: View method for \linkS4class{RLum.Analysis} objects.

\item \code{view(RLum.Data)}: View method for \linkS4class{RLum.Data} objects.

\item \code{view(RLum.Results)}: View method for \linkS4class{RLum.Results} objects.

\item \code{view(Risoe.BINfileData)}: View method for \linkS4class{Risoe.BINfileData} objects.

}}
\seealso{
\code{\link[utils:View]{utils::View()}}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. view(): Convenience data visualisation function. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
