% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_helper.R
\name{Datetime_limits}
\alias{Datetime_limits}
\title{Find or set sensible limits for Datetime axis}
\usage{
Datetime_limits(
  x,
  start = NULL,
  length = NULL,
  unit = "1 day",
  midnight.rollover = FALSE,
  ...
)
}
\arguments{
\item{x}{a vector of \code{Datetimes}}

\item{start}{optional \code{duration} object, e.g. \code{lubridate::ddays(1)} that
shifts the start of the \code{Datetime} vector by this amount.}

\item{length}{optional \code{duration} object, e.g. \code{lubridate::ddays(7)} that
shifts the end of the \code{Datetime} vector by this amount from the (adjusted)
start. Depending on the data, you might have to subtract one day from the
desired length to get the correct axis-scaling if you start at midnight.}

\item{unit}{a \code{character} scalar giving the unit of rounding in
\code{\link[lubridate:round_date]{lubridate::floor_date()}} and \code{\link[lubridate:round_date]{lubridate::ceiling_date()}}}

\item{midnight.rollover}{a \code{logical} scalar indicating whether to rollover in cases of exact matches of rounded values and input values. Helpful if some cases fall exactly on the rounded values and others don`t.}

\item{...}{other arguments passed to \code{\link[lubridate:round_date]{lubridate::floor_date()}} and
\code{\link[lubridate:round_date]{lubridate::ceiling_date()}}}
}
\value{
a 2 item \code{vector} of \code{Datetimes} with the (adjusted) start and end of
the input vector.
}
\description{
Take a vector of \code{Datetimes} and return the start of the first and end of the
last day of data. The \code{start} and the \code{length} can be adjusted by
\code{durations}, like \code{\link[lubridate:duration]{lubridate::ddays()}}. It is used in the \code{\link[=gg_days]{gg_days()}}
function to return a sensible x-axis. This function is a thin wrapper around
\code{\link[lubridate:round_date]{lubridate::floor_date()}} and \code{\link[lubridate:round_date]{lubridate::ceiling_date()}}.
}
\examples{
dataset <- c("2023-08-15", "2023-08-20")
breaks <- Datetime_breaks(dataset)
Datetime_limits(breaks)
Datetime_limits(breaks, start = lubridate::ddays(1))
Datetime_limits(breaks, length = lubridate::ddays(2))
}
