% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mccoef.r
\name{as.matrix.htlr.fit}
\alias{as.matrix.htlr.fit}
\title{Create a Matrix of Markov Chain Samples}
\usage{
\method{as.matrix}{htlr.fit}(x, k = NULL, include.warmup = FALSE, ...)
}
\arguments{
\item{x}{An object of S3 class \code{htlr.fit}.}

\item{k}{Coefficients associated with class \code{k} will be drawn. Must be a positive integer in 
1,2,\ldots,C-1 for C-class traning labels (base class 0 can not be chosen). By default the last class
is selected. For binary logistic model this argument can be ignored.}

\item{include.warmup}{Whether or not to include warmup samples}

\item{...}{Not used.}
}
\value{
A matrix with \code{(p + 1)} columns and \code{i} rows, where \code{p} is the number of features 
excluding intercept, and \code{i} is the number of iterations after burnin.
}
\description{
The Markov chain samples (without warmup) included in a \code{htlr.fit} object will be coerced to a matrix.
}
\examples{
## No. of features used: 100; No. of iterations after burnin: 15 
fit <- htlr(X = colon$X, y = colon$y, fsel = 1:100, iter = 20, warmup = 5)

dim(as.matrix(fit))
  
}
