% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score}
\alias{score}
\title{score}
\usage{
score(y, mu, sigma, md = FALSE)
}
\arguments{
\item{y}{response variable vector}

\item{mu}{predicted mean vector}

\item{sigma}{predicted covariance matrix}

\item{md}{logical indicating whether to return to a Mahalanobis distance value (\code{md = TRUE}) and score value or
only a score value (\code{md = FALSE})}
}
\value{
a numerical value
}
\description{
Calculates a score value. Higher score values indicate better fits.
}
\examples{

### test function ###
f_x <- function(x) {
return(sin(2*pi*x) + x^2)
}

### training data ###
n <- 8
x <- runif(n, 0, 1)
y <- f_x(x)

### testing data ###
n.test <- 100
x.test <- runif(n.test, 0, 1)
y.test <- f_x(x.test)

### get parameter estimates ###
out <- mle_gp(y, x)

### prediction ###
pred <- predict_gp(out, x.test)

### get score value ###
score_value <- score(y.test, pred$mup, pred$Sigmap)

}
